#import "Object_Document.h"
#import "Object_AllocNDebug.h"
#import <appkit/appkit.h>

/* Category variables */
static const char *gLastOpenPath;
static const char *gLastSavePath;
static const char *gLastFilename;

@implementation Object(Document)

- (const char *) openFileTypes:(const char *const *) fileTypes
	directory:(const char *) path file:(const char *) filename
	forDirectory:(BOOL) flag
{
OpenPanel *openPanel;
BOOL isOk;

[self debug: MAX_DEBUG method: _cmd, "path = %s\n", path];

	if( path == NULL )
		path = [self lastOpenPath];

	errno = 0;
	openPanel = [OpenPanel new];
	[openPanel chooseDirectories: flag];
	isOk = [openPanel runModalForDirectory: path file: filename
			types: fileTypes];
	if( isOk == NO )
		return NULL;	// user Canceled
	gLastFilename = filename = [openPanel filename];
	gLastOpenPath = [openPanel directory];

	return gLastFilename;
}

- (const char *) saveFileType:(const char *) type
	directory:(const char *) path file:(const char *) filename
{
SavePanel *savePanel;
BOOL isOk;
char tmpName[MAXPATHLEN], *tmpPtr;

	if( path == NULL )
		path = [self lastSavePath];
	errno = 0;
	savePanel = [SavePanel new];
	[savePanel setRequiredFileType: type];
	/* If this is a full pathname break it into the path and file */
	if( filename != NULL && rindex(filename, '/') != NULL )
	{
		strcpy(tmpName, filename);
		tmpPtr = rindex(filename, '/');
		if( tmpPtr == filename )
		{	/* Root directory path */
			path = "/";
			filename = ++ tmpPtr;
		}
		else
		{
			*tmpPtr = '\0';
			path = tmpName;
			filename = ++ tmpPtr;
		}
	}
	isOk = [savePanel runModalForDirectory: path file: filename];
	if( isOk == NO )
		return NULL;	// user Canceled
	gLastFilename = filename = [savePanel filename];
	gLastSavePath = [savePanel directory];

	return gLastFilename;
}

/* Return a typed stream to be used to read in a document with
	file extensions "fileTypes".  It displays an OpenPanel using the method
	streamForDoc:directory:file:prompt: */
- (NXTypedStream *) readStreamForDoc:(const char *const *) fileTypes
	file:(const char *) filename
{
NXTypedStream *stream;

	stream = [self readStreamForDoc: fileTypes directory: NULL file: filename
		prompt: YES];
	return stream;
}

/* Return a typed stream to be used to read in a document with
	file extensions "fileTypes".  It displays an OpenPanel if prompt
	is YES, else it opens the file given by directory/filename */
- (NXTypedStream *) readStreamForDoc:(const char *const *) fileTypes
	directory:(const char *) path file:(const char *) filename
	prompt:(BOOL) prompt
{
NXTypedStream *stream;

	if( path == NULL )
		path = [self lastOpenPath];

[self debug: MAX_DEBUG method: _cmd, "path = %s\n", path];

	errno = 0;
	if( prompt == YES )
	{
		filename = [self openFileTypes: fileTypes directory: path
				file: filename forDirectory: NO];
		if( filename == 0 )
			return 0;	// user Canceled
		gLastFilename = filename;
	}
	else if( filename == NULL )
	{
		NXRunAlertPanel(NULL,"You must specify a filename to %s:streamForDoc",
			NULL, NULL, NULL, [[self class] name]);
		return NULL;
	}

[self debug: MAX_DEBUG method: _cmd, "opening = %s\n", filename];
	stream = NXOpenTypedStreamForFile(filename, NX_READONLY);
	return stream;
}


/* Return a typed stream that can be used to save a document with
	a file extension of "type".  It displays a SavePanel using the method
	streamForSave:directory:file: */
- (NXTypedStream *) writeStreamForDoc:(const char *) type
{
NXTypedStream *stream;

	stream = [self writeStreamForDoc: type directory: NULL
		file: NULL prompt: YES];
	return stream;
}

/* Return a typed stream that can be used to save a document with
	a file extension of "type", by prompting the user with a SavePanel
	that is intialized to the path specified by "path" & prompt "filename". */
- (NXTypedStream *) writeStreamForDoc:(const char *) type
	directory:(const char *) path file:(const char *) filename
	prompt:(BOOL) prompt
{
NXTypedStream *stream;
char tmpName[MAXPATHLEN];

	if( path == NULL )
		path = [self lastSavePath];
	errno = 0;
	if( prompt == YES )
	{
		filename = [self saveFileType: type directory: path
			file: filename];
	}
	else if( filename == NULL )
	{
		sprintf(tmpName, "%s/Untitled", path);
		filename = tmpName;
	}

	stream = NXOpenTypedStreamForFile(filename, NX_WRITEONLY);
	return stream;
}

- (const char *) lastOpenPath
{
const char *directory = gLastOpenPath;

	if( gLastOpenPath == NULL )
		directory = NXHomeDirectory();

	return directory;
}

- (const char *) lastSavePath
{
const char *directory = gLastSavePath;

	if( directory == NULL )
		directory = NXHomeDirectory();

	return directory;
}

- (const char *) lastFilename
{
	return gLastFilename;
}

@end
/* RCS Information:
	$Author: me $;
	$Date: 93/02/23 02:01:22 $;
	$Source: /usr1/me/NeXTSrc/MyClasses/RCS/Object_Document.m,v $;
	$Revision: 1.1 $;
	$Log:	Object_Document.m,v $
Revision 1.1  93/02/23  02:01:22  me
Begin RCS logging.
;
*/
