/* An Object classification that adds a number of methods useful
	for document types of objects. */
#import <objc/Object.h>
#import <objc/typedstream.h>

@interface Object(Document)
/* Displays an open panel for files of 'fileTypes' with the
	initial directory of 'path' looking for 'filename'. Selection
	of directories is allowed if 'flag' is YES. Returns
	the filename choosen or 0 if cancelled. */
- (const char *) openFileTypes:(const char *const *) fileTypes
	directory:(const char *) path file:(const char *) filename
	forDirectory:(BOOL) flag;

/* Displays a save panel for file 'type' with the
	initial directory of 'path' looking to save 'filename'. Returns
	the filename choosen or 0 if cancelled. */
- (const char *) saveFileType:(const char *) type
	directory:(const char *) path file:(const char *) filename;

/* Return a typed stream to be used to read in a document with
	file extensions "fileTypes".  It displays an OpenPanel using the method
	streamForDoc:directory:file:prompt: */
- (NXTypedStream *) readStreamForDoc:(const char *const *) fileTypes
	file:(const char *) filename;

/* Return a typed stream to be used to read in a document with
	file extensions "fileTypes".  It displays an OpenPanel if prompt
	is YES, else it opens the file given by directory/filename */
- (NXTypedStream *) readStreamForDoc:(const char *const *) fileTypes
	directory:(const char *) path file:(const char *) filename
	prompt:(BOOL) prompt;

/* Return a typed stream that can be used to save a document with
	a file extension of "type".  It displays a SavePanel using the method
	streamForSave:directory:file:prompt: */
- (NXTypedStream *) writeStreamForDoc:(const char *) type;
 
/* Return a typed stream that can be used to save a document with
	a file extension of "type", by prompting the user with a SavePanel
	that is intialized to the path specified by "path" & prompt "filename" if
	"prompt" is YES, else it just opens the file given by directory/filename. */
- (NXTypedStream *) writeStreamForDoc:(const char *) type
	directory:(const char *) path file:(const char *) filename
	prompt:(BOOL) prompt;

- (const char *) lastOpenPath;
- (const char *) lastSavePath;
- (const char *) lastFilename;
@end
