/* An Object classification that incorporates a number of methods for 
	memory allocation and debugging */
#import <objc/Object.h>
#import <stdio.h>
#import <stdarg.h>

@interface Object(AllocNDebug)

/* Debug level and error defines. */
#define NO_DEBUG -1
#ifdef DEBUG	/* Report these depending on appDebugLevel */
#	define LOW_DEBUG 10
#	define MED_DEBUG 20
#	define MAX_DEBUG 30
#	define SUPER_DEBUG 40
#else			/* These are turned off when DEBUG is undefined */
#	define LOW_DEBUG 9999
#	define MED_DEBUG 9999
#	define MAX_DEBUG 9999
#	define SUPER_DEBUG 9999
#endif

/* Serverity defines for error: key: */
	// A failure to achieve some noncritical state
#define INTERNAL_SORRY	100
	// An error that probably means the progam state is bad
#define INTERNAL_ALERT	200
	// A failure to achieve some state the program requires
#define INTERNAL_ERROR	300

/*\ ---------------------- Initialization Methods ---------------------- \*/
/* Initialize the Object class variables which are added by
	this classification for use with the debugging methods */
+ initialize;
- setErrorTable: table;
- setErrorFile:(FILE *) file;
- setAppDebugLevel:(int) level;
- (int) appDebugLevel;

/*\ ---------------------- Allocation Methods ---------------------- \*/
/* These methods are basic covers to the system memory allocation
	routines with that addition of result checking for allocation failure */
- (void *) malloc:(int) sizeInBytes;
- (void *) realloc:(int) sizeInBytes oldPtr:(void *) ptr;
- (char *) stringAlloc:(const char *) source copyTo:(char **) destination;
- (char *) buildMsg:(char *) format, ...;
- (char *) buildMsg:(char *) format argList:(va_list) argList;
- (void) free:(void *) ptr;

/*\ ---------------------- Error Message Methods ---------------------- \*/
/* Ask the user the yes, no question in the "question" arg with
	a cancel option if "cancel" is YES.  The method returns
	one of the three constants returned by NXRunAlertPanel(). */
- (int) askYesNo:(const char *) question cancel:(BOOL) cancel;

/* Report alert with an Ok & Quit button using the msg argument */
- (int) alertOk:(const char *) msg quit:(BOOL) quit;

/* Generic alert method. Returns one of NX_ALERTDEFAULT, NX_ALERTALTERNATE
	NX_ALERTOTHER. */
- (int) alert: (const char *) title msg:(const char *) format
	btn1:(const char *) theDefault btn2:(const char *) alternate
	btn3:(const char *) other, ...;

/* Report system call errors and then return. The error message uses
	the string returned strerror(). */
- systemErr: (char *) format method:(SEL) method, ...;

/* Report the error associated with the keyString and continue,
	depending on the severity.  One object in the application importing
	this category must set the errStringTable using the setErrTable method. */
- error:(int) severity method:(SEL) method key:(const char *) keyString, ...;

/* Report debugging information depending on the debugLevel arg.
	A message is logged if debugLevel is less than the class
	variable appDebugLevel. */
- debug: (int) debugLevel method:(SEL) method, ...;

@end
/* RCS Information:
	$Author: me $;
	$Date: 93/02/23 02:01:07 $;
	$Source: /usr1/me/NeXTSrc/MyClasses/RCS/Object_AllocNDebug.h,v $;
	$Revision: 1.1 $;
*/
