#import "ObjectArchival.h"

#import <appkit/appkit.h>

static char *errorMsgFormats[] = {
// eBadObjVersion
	"Bad %s archive version[%d]\n",
// eVlinkReadErr
	"Failed to unarchive vlink\n",
// eWrongClassName
	"Unexpected class obj in archive [%s], expected [%s]\n",
// eListReadErr
	"Failed to unarchive List\n",
// eUnknownArchiveClass
	"Failed to find class [%s]\n",
// eNonconformingClass
	"Class [%s] does not conform to ObjectArchival protocol\n",
// eObjReadErr
	"Failed to unarchive object of class [%s]\n"
};

/* The error reporter for ObjectArchival exceptions */
void ObjectArchivalError(NXHandler *errorState)
{
char *exceptionFmt;

	exceptionFmt = errorMsgFormats[errorState->code - NX_APPBASE];
	NXLogError(exceptionFmt, errorState->data1, errorState->data2);
	NXRunAlertPanel("Exception", exceptionFmt, "Ok", "Quit", NULL,
		errorState->data1, errorState->data2);
}
/* RCS Information:
	$Author: me $;
	$Date: 93/02/23 02:01:39 $;
	$Source: /usr1/me/NeXTSrc/MyClasses/RCS/ObjectArchival.m,v $;
	$Revision: 1.1 $;
	$Log:	ObjectArchival.m,v $
Revision 1.1  93/02/23  02:01:39  me
Begin RCS logging.
;
*/
