/* A formal protocol declaring the methods required to archive objects
	to and from a typed stream without introducing the system
	dependence problems that the NXWriteObject, NXReadObject, ... functions
	and -write:, -read: methods do. */
#import <objc/typedstream.h>
#import <appkit/errors.h>

/* Typed stream exception enums for use with ObjectArchival
	protocol methods.  The data1 & data2 comments refer to what
	info should be passed at those args to the NX_RAISE() macro. 
	All exceptions are raised to the exception handler in the
	ArchieSession class. */
enum {
	eBadObjVersion = NX_APPBASE,	// data1 = ObjClassName, data2 = version
	eVlinkReadErr,			// data1 = msg, data2 = NULL
	eWrongClassName,		// data1 = unexpected name, data2 = expected name
	eListReadErr,			// data1 = msg, data2 = NULL
	eUnknownArchiveClass,	// data1 = ObjClassName, data2 = NULL
	eNonconformingClass,	// data1 = ObjClassName, data2 = NULL
	eObjReadErr,			// data1 = ObjClassName, data2 = NULL
	END_ObjectArchival_EXCEPTIONS
};

@class Protocol;

@protocol ObjectArchival
- initFromTStream:(NXTypedStream *) stream;
- readFromTStream:(NXTypedStream *) stream;
- writeToTStream:(NXTypedStream *) stream;
@end

extern void ObjectArchivalError(NXHandler *errorState);
 
/* RCS Information:
	$Author: me $;
	$Date: 93/02/23 02:01:34 $;
	$Source: /usr1/me/NeXTSrc/MyClasses/RCS/ObjectArchival.h,v $;
	$Revision: 1.1 $;
	$Log:	ObjectArchival.h,v $
 * Revision 1.1  93/02/23  02:01:34  me
 * Begin RCS logging.
 * ;
*/
