/* A view class that dissolves one image into another */
#import <appkit/View.h>

@class List, NXImage;

@interface MorphView : View
{
	id delegate;		// Drawing delegate object
	List *imageList;	// The NXImages which dissolve into one another
	id morphTrigger;	// The sender of the first morph: message
	int imageIndex;		// Index of image currently displayed
	int imageDelay;		// Amount of time(ms) between dissolves
	float imageDelta;	// Delta factor of dissolve:toPoint:
}

- initFrame:(const NXRect *) frame;
- initFrame:(const NXRect *) frame images: images delay:(int) delay
	delta:(float) delta;
- setImages: images delay:(int) delay delta:(float) delta;
- setDelegate: newDelegate;

- (int) count;
- (float) delta;
- morph: sender;
- drawSelf:(const NXRect *) rects :(int) rectCount;

@end

@interface MorphView(Delegate)
// Delegate methods
- (BOOL) hasDrawMethodFor: image imageNum:(int) num;
- performDrawFor: image imageNum:(int) num inView: view;
@end

/* RCS Information:
	$Author: me $;
	$Date: 93/02/23 02:00:49 $;
	$Source: /usr1/me/NeXTSrc/MyClasses/RCS/MorphView.h,v $;
	$Revision: 1.1 $;
*/
