// MOStringDebugging.m
//
// by Mike Ferris
// Part of MOKit
// Copyright 1993, all rights reserved.

// ABOUT MOKit
// by Mike Ferris (mike@lorax.com)
//
// MOKit is a collection of useful and general objects.  Permission is 
// granted by the author to use MOKit in your own programs in any way 
// you see fit.  All other rights pertaining to the kit are reserved by the 
// author including the right to sell these objects as objects,  as part 
// of a LIBRARY, or as SOURCE CODE.  In plain English, I wish to retain 
// rights to these objects as objects, but allow the use of the objects 
// as pieces in a fully functional program.  Permission is also granted to 
// redistribute the source code of MOKit for FREE as long as this copyright 
// notice is left intact and unchanged.  NO WARRANTY is expressed or implied.  
// The author will under no circumstances be held responsible for ANY 
// consequences from the use of these objects.  Since you don't have to pay 
// for them, and full source is provided, I think this is perfectly fair.

#import "MOString.h"

extern char *MOBuildStringFromFormatV(const char *formatStr, 
			va_list param_list);

@implementation MOString(Debugging)

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// =-=-=-=-=-=-=-=-=-=-=-=-=-=- Debug  printing -=-=-=-=-=-=-=-=-=-=-=-=-=-=
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

- buildInstanceImageIn:(char *)buf
// Build a nice representation of all our instance vars in buf.
{
	sprintf(buf, "\tstr = '%s' (%#x)\n\tuStr = '%s' (%#x)\n"
				"\tlen = %lu\n\tisUnique = %s, shouldFree = %s\n", 
				str, (unsigned int)str, uStr, 
				(unsigned int)uStr, len, (isUnique?"YES":"NO"), 
				(shouldFree?"YES":"NO"));
	return self;
}

- printForDebugger:(NXStream *)stream
// Overriden to use our nice instance printer as well as what it used to do.
{
	char buf[1000];
	
	[super printForDebugger:stream];
	[self buildInstanceImageIn:buf];
	NXWrite(stream, buf, strlen(buf));
	
	return self;
}

- printToStdErr:(const char *)label
// Prints a nice representation of our string to the stderr labeled with
// the given label.
{
	char buf[1000];
	
	fprintf(stderr, "%s <%s:%#x>\n", label, [[self class] name], 
				(unsigned int)self);
	[self buildInstanceImageIn:buf];
	fprintf(stderr, "%s", buf);
	
	return self;
}

@end

