// MOPathString.h
//
// by Mike Ferris
// Part of MOKit
// Copyright 1993, all rights reserved.

// ABOUT MOKit
// by Mike Ferris (mike@lorax.com)
//
// MOKit is a collection of useful and general objects.  Permission is 
// granted by the author to use MOKit in your own programs in any way 
// you see fit.  All other rights pertaining to the kit are reserved by the 
// author including the right to sell these objects as objects,  as part 
// of a LIBRARY, or as SOURCE CODE.  In plain English, I wish to retain 
// rights to these objects as objects, but allow the use of the objects 
// as pieces in a fully functional program.  Permission is also granted to 
// redistribute the source code of MOKit for FREE as long as this copyright 
// notice is left intact and unchanged.  NO WARRANTY is expressed or implied.  
// The author will under no circumstances be held responsible for ANY 
// consequences from the use of these objects.  Since you don't have to pay 
// for them, and full source is provided, I think this is perfectly fair.

// ABOUT MOPathString
//
// MOPathString is a subclass of MOString that adds a few methods that
// are very useful when dealing with file paths.  It is cool for use 
// in conjunction with open and save panels, or any other situation 
// where you need to access file path information

#import "MOString.h"

@interface MOPathString:MOString
{
	char pathSeparator;
	char extSeparator;
}

// =-=-=-=-=-=-=-=-=-=-=-=- Initializing  the class -=-=-=-=-=-=-=-=-=-=-=-=

+ initialize;

// =-=-=-=-=-=-=-=-=-=-=-=-=- Initializing  paths -=-=-=-=-=-=-=-=-=-=-=-=-=

- initPath:(const char *)path;
- initDirectory:(const char *)dir file:(const char *)file;
- initStringValueNoCopy:(char *)s shouldFree:(BOOL)flag;	// DI

// =-=-=-=-=-=-=-=-=-=-=-=-=-= Configuring paths =-=-=-=-=-=-=-=-=-=-=-=-=-=

- setPath:(const char *)path;
- setDirectory:(const char *)dir file:(const char *)file;

- setPathSeparator:(char)c;
- (char)pathSeparator;

- setExtensionSeparator:(char)c;
- (char)extensionSeparator;

// =-=-=-=-=-=-=-=-=- Accessing important parts of a path -=-=-=-=-=-=-=-=-=

- (const char *)path;

- directory;
- file;
- fileExtension;
- fileBasename;

- (int)numberOfComponents;
- componentAt:(int)index;

// =-=-=-=-=-=-=-=-=-=-=-=-=-= Testing  the file =-=-=-=-=-=-=-=-=-=-=-=-=-=

- (BOOL)isRelative;
- (BOOL)isAbsolute;
- (BOOL)doesExistInFileSystem;

- (BOOL)isDirectory;
- (BOOL)isPlainFile;
- (BOOL)isSymbolicLink;
- (BOOL)isCharacterSpecial;
- (BOOL)isBlockSpecial;
- (BOOL)isSocket;

// =-=-=-=-=-=-=-=-=-=-=-=-=-= Archiving methods =-=-=-=-=-=-=-=-=-=-=-=-=-=

- write:(NXTypedStream *)typedStream;
- read:(NXTypedStream *)typedStream;

// =-=-=-=-=-=-=-=-=-=-=-=-= NXTransport  protocol =-=-=-=-=-=-=-=-=-=-=-=-=

- encodeUsing:(id <NXEncoding>)portal;
- decodeUsing:(id <NXDecoding>)portal;



@end
