/* A date class based on the routines in COMPUTER LANGAUGE V7, No12, 1990
	page 57-62 */
#ifndef DATE_H
#define DATE_H
#import <objc/Object.h>
#import "ObjectArchival.h"	// Archival protocol

typedef long JulianDate;
typedef short WeekDay;
typedef short Day;
typedef short Month;
typedef short Year;

@interface Date : Object <ObjectArchival>
{
	char *dateString;		// A date string in the form day/month/year
	JulianDate date;		// The Julian day number
	/* The corresponding integer values */
	Day day;		// 1-31
	Month month;	// 1-12
	Year year;		// year <  100 => year = year + CurrentCentury
					// year >= 100 => year = year
	/* The 24 hour time */
	short hours;	// 0-23
	short minutes;	// 0-59
	short seconds;	// 0-59

	/* The error mode flag */
	char errorMode;
}

/* Actions */

/* Class methods */
+ (const char *) selName : (SEL) theSEL;

/* initialization methods */
- initFromString : (char *) theDate;
- initFromDate : (Day) d : (Month) m : (Year) y;
- initFromJulianDate : (JulianDate) jDate;
- initFromNow;
- setTime : (short) hr : (short) min : (short) sec;
- free;

/* Set whether an invalid date will either
	1) Simply return a nil object: mode = 0 (this is the default)
	2) Display an alert panel and then return nil: mode = 1
	3) Display an alert panel and allow the user to correct the date: mode = 2
*/
- setErrorMode : (int) mode;

/* Conversion functions */
// Returns the calendar date of jDate
- calendarDate : (JulianDate) jDate : (Day *) d : (Month *) m : (Year *) y;
- (JulianDate) julianRep : (Day) d : (Month) m : (Year) y;  // Returns the Julian rep for the calendar date
- (JulianDate) julianDate;	// Returns the date in its Julian representation
- (Day) day;				// Returns the day of the month
- (Month) month;			// Returns the month [0-11]
- (Year) year;				// Returns the year
- (short) hours;			// Returns the hours
- (short) minutes;			// Returns the minutes
- (short) seconds;			// Returns the seconds
- (unsigned long) extendedDate;
- (void) time : (short *) hr : (short *) min : (short *) sec;  // Set to the objects time
- (const char *) stringDate;		// Returns the date in the form "m/d/yyyy"
- (const char *) stringFixedDate;	// Returns the date in the form "mm/dd/yyyy"
- (const char *) fullStringDate;	// Returns the date in the form "DayOfWeek Month dd Year"
- (const char *) time24hr;	// Returns the time string "hh:mm"
- (const char *) timeAM_PM;	// Returns the time string "h[h]:mm [AP]m" where h <= 12
- (WeekDay) weekDay;		// Returns the day of the week Sun-Sat [0-6]
- (int) weekOfYear;			// Returns the week number of the year [0-51]

/* System time access */
// Set the componets to those returned by localtime(3)
- (void) now : (Day *) d : (Month *) m : (Year *) y : (short *) hr 
	: (short *) min : (short *) sec;
// Return the system clock time(3)
- (long) sysTime;

/* Ouput */
- (void) print;

/* Private methods to check the date and report errors */
- (BOOL) validDate;
- invalidDate : (SEL) callingMethod;
/* Method invoked by the Ok button of the editErrorPanel */
- dateOk : sender;
/* Method invoked by the ``Return nil'' button of the editErrorPanel */
- dateCancel : sender;

/*\ ---------------------- ObjectArchival Protocol ---------------------- \*/
/* The current version for new documents */
#define DATE_VERS		1	// Object release version
#define DATE_SUBVERS	0	// Object subrelease version
#define DATE_TYPE		0	// Object version type
/* Object versions we know about */
#define DATE_VERSION_0 1000

- initFromTStream:(NXTypedStream *) stream;
- readFromTStream:(NXTypedStream *) stream;
- writeToTStream:(NXTypedStream *) stream;

@end
/*\ -------------------- Error & Debugging Categories -------------------- \*/
#import "Object_AllocNDebug.h"

/* RCS Information:
	$Author: me $;
	$Date: 93/02/23 02:00:30 $;
	$Source: /usr1/me/NeXTSrc/MyClasses/RCS/Date.h,v $;
	$Revision: 1.1 $;
*/
#endif DATE_H
