// ClockView.h
// By Jayson Adams, NeXT Developer Support Team
// You may freely copy, distribute and reuse the code in this example.
// NeXT disclaims any warranty of any kind, expressed or implied, as to its
// fitness for any particular use.
/* Modified by Scott Stark, Thu Jan 16 1992 */

#import <appkit/View.h>
#import <dpsclient/dpsclient.h>
#import <mach/cthreads.h>

@interface ClockView : View
{
	/* The NXImages used to display the clock */
	id	clockImage;
	id	numbers[10];
	id	amImage;
	id	pmImage;
	id	colon;
	id	meridianImage;
	NXPoint	colonPosition_clock;	// : position for normal time
	NXPoint colonPosition_timer;	// : position for timer
	/* My Date class object used to store the time and date */
	id	dateObj;
	/* The timed entry procedure activated by the startMinSecTimer: method */
	long t_start, t_now;
	long t_min, t_sec;
	port_t timerPort;
	cthread_t timerCthread;
	BOOL timerActive;
}

/* instance methods */
- initFrame : (const NXRect *) frameRect;
- drawSelf : (NXRect *) rects : (int) count;

/* Date initialization methods */
- setDate : (short) d : (short) m : (short) y;
- setTime : (short) hr : (short) min : (short) sec;
- now;

/* A minute/second timer display method */
- startMinSecTimer : sender;
- endTimer : sender;

@end
/* RCS Information:
	$Author: me $;
	$Date: 93/02/23 02:00:21 $;
	$Source: /usr1/me/NeXTSrc/MyClasses/RCS/ClockView.h,v $;
	$Revision: 1.1 $;
*/
