// CalendarView.m
// By Jayson Adams, NeXT Developer Support Team
// You may freely copy, distribute and reuse the code in this example.
// NeXT disclaims any warranty of any kind, expressed or implied, as to its
// fitness for any particular use.
/* Modified by Scott Stark, Fri Jan 17 1992 */
#import "CalendarView.h"
#import <Date.h>

#import <appkit/appkit.h>
#import <math.h>

@implementation CalendarView


/* instance methods */

- initFrame : (NXRect *) frameRect
{
int i;
char *numberNames[] = {"Zero", "One", "Two", "Three", "Four", "Five",
				"Six", "Seven", "Eight", "Nine", ""},
*smallNumberNames[] = {"SmallZero", "SmallOne", "SmallTwo", "SmallThree", "SmallFour",
				"SmallFive","SmallSix", "SmallSeven", "SmallEight", "SmallNine", ""},
*dayNames[] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat",""},
*monthNames[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
				"Aug", "Sep", "Oct", "Nov", "Dec", ""};
			  
	[super initFrame:frameRect];
	
	/* find all of the images */
	calendarImage = [NXImage findImageNamed:"YearCalendar"];
	
	for (i = 0; *numberNames[i]; i++)
	{
		numbers[i] = [NXImage findImageNamed: numberNames[i]];
		smallNumbers[i] = [NXImage findImageNamed: smallNumberNames[i]];
	}

	for (i = 0; *dayNames[i]; i++) 
		days[i] = [NXImage findImageNamed: dayNames[i]];
	
	for (i = 0; *monthNames[i]; i++) 
		months[i] = [NXImage findImageNamed: monthNames[i]];
	
	/* Initialize the Date object to the current date */
	dateObj = [[Date alloc] initFromNow];

	return self;
}

- setDate:(long) julianDate
{
	if( [dateObj initFromJulianDate: julianDate] == nil )
		return nil;
	[self display];

	return self;
}
- setDate : (short) day : (short) month : (short) year
{
	if( [dateObj initFromDate : day : month : year] == nil )
		return nil;
	[self display];

	return self;
}
- today
{
	if( [dateObj initFromNow] == nil )
		return nil;
	[self display];

	return self;
}

- drawSelf:(NXRect *)rects :(int)count
{
NXSize calendarSize, unitSize, tenSize, size;
NXSize thousandSize,hundredSize;
NXPoint position;
float numberWidth,yOffset = 9.0;
short day,month,year,dayOfWeek;
short thousands,hundreds,tens,ones;

	day = [dateObj day];
	month = [dateObj month];
	year = [dateObj year];
	dayOfWeek = [dateObj weekDay];

	[calendarImage getSize:&calendarSize];

/* draw the background */
	[calendarImage composite:NX_SOVER toPoint:&(bounds.origin)];

/* we want to center the date on the calendar;  compute its location */
	[numbers[day % 10] getSize:&unitSize];
	numberWidth = unitSize.width;
	if (day / 10)
	{
		[numbers[day / 10] getSize:&tenSize];
		numberWidth += tenSize.width;
	}
	position.x = floor((calendarSize.width - numberWidth) / 2.0) - 1.0;
	position.y = 14.0 + yOffset;

/* draw the date */
	if (day / 10)
	{
		[numbers[day / 10] composite:NX_SOVER toPoint:&position];
		position.x += tenSize.width;
	}
	[numbers[day % 10] composite:NX_SOVER toPoint:&position];

/* draw the day */
	[days[dayOfWeek] getSize:&size];
	position.x = floor((calendarSize.width - size.width) / 2.0) - 2.0;
	position.y = 33.0 + yOffset;
	[days[dayOfWeek] composite:NX_SOVER toPoint:&position];

/* draw the month */
	[months[month] getSize:&size];
	position.x = floor((calendarSize.width - size.width) / 2.0) - 2.0;
	position.y = 8.0 + yOffset;
	[months[month] composite:NX_SOVER toPoint:&position];

/* Draw the year */
	thousands = year / 1000;
	hundreds = (year - 1000 * thousands) / 100;
	tens = (year - 1000 * thousands - 100 * hundreds) / 10;
	ones = (year - 1000 * thousands - 100 * hundreds - 10 * tens);
	[smallNumbers[thousands] getSize: &thousandSize];
	[smallNumbers[hundreds] getSize: &hundredSize];
	[smallNumbers[tens] getSize: &tenSize];
	[smallNumbers[ones] getSize: &unitSize];
	numberWidth = thousandSize.width + hundredSize.width + tenSize.width + unitSize.width;
	position.x = floor((calendarSize.width - numberWidth) / 2.0) - 2.0;
	position.y = 1.0;
	[smallNumbers[thousands] composite: NX_SOVER toPoint: &position];
	position.x += thousandSize.width;
	[smallNumbers[hundreds] composite: NX_SOVER toPoint: &position];
	position.x += hundredSize.width;
	[smallNumbers[tens] composite: NX_SOVER toPoint: &position];
	position.x += tenSize.width;
	[smallNumbers[ones] composite: NX_SOVER toPoint: &position];

	return self;
}

@end
/* RCS Information:
	$Author: me $;
	$Date: 93/02/23 02:00:16 $;
	$Source: /usr1/me/NeXTSrc/MyClasses/RCS/CalendarView.m,v $;
	$Revision: 1.1 $;
*/
