// InspectorManager.h
// By Kevin Brain (ksbrain@zeus.UWaterloo.ca)

// A class that manages the displaying of elements of a list of view 
// objects that are periodically displayed and removed from a window.

// Compositing techniques and functions from ToolInspector example
// by Sharon Biocca Zakhour, NeXT Developer Support Team
// You may freely copy, distribute and reuse the code in this example.  
// *Everybody involved* disclaims any warranty of any kind, expressed 
// or implied, as to its fitness for any particular use.

#import <objc/Object.h>
#import <appkit/graphics.h>

/* Inspector Type */
#define MESSAGE 0

#define FIRSTADDEDINSPECTOR 1
#define LOWERLEFTX 10
#define LOWERLEFTY 40

@interface InspectorManager:Object
{
    id	inspectorPanel;
    id	messagePanel;
    id	inspectorStrings;
	id 	messageTextField;
	id	messageBox;
	id	delegate;
	id	revertOKOut;
	id	popupOut;		// attaches to button that covers popup list
	id	inspectorList;
	id	groupList;
	id	visibleInspectors;	/* Storage of visible inspector numbers */
	NXRect	lastRect;
	BOOL useKeyEquivalents;
	struct inspectorListEntry {	// list of inspector info
		id	view;				// the box composing the inspector
		id	cacheWindow;		// offscreen window that caches the view
		char *title;			// pointer to inspector title
		BOOL showing;			// YES if showing in the panel
		BOOL cached;			// YES if the view is cached
		NXRect offscreenRect;	// rect in layout view for compositing
		};	
}	


/* instance methods */
- init;
- initFromNib:(const char *) nibFile;
- (unsigned int)addInspector:(id)theView title:(const char *)theTitle;
- (unsigned int)addInspector:(id)theView title:(const char *)theTitle 
	atLocation:(NXCoord)xLoc :(NXCoord)yLoc
	cached:(BOOL)isCached cacheWindow:(id)theCacheWindow;
- (unsigned int)addGroup:(const char *)theTitle;
- setUseKeyEquivalents:(BOOL)use;
- switchToInspector:(unsigned int)newInspectorNum;
- showInspector:(unsigned int)inspectorNum;
- hideInspector:(unsigned int)inspectorNum;
- (BOOL)showing:(unsigned int)inspectorNum;
- (int)group;
- showMessage:(const char *)theMessage;
- messageTextField;
- panel;
- popUpListButton;
- revertOKMatrix;
- setDelegate:(id)anObject;
- delegate;
- selectGroup:sender;
- revertPressed:sender;
- okPressed:sender;
- showRevertOK;
- hideRevertOK;
- showGroupPopUp;
- hideGroupPopUp;
@end

@interface Object(InspectorManagerDelegate)
- groupChanged:sender to:(int)newGroup;
- inspectRevert:sender;
- inspectOK:sender;
@end

