/* InspectorInfo is a abstract subclass of Object that encapsulates
	information related to a inspected object attribute.  An example would
	be the size of a View.
	InspectorInfo objects are passed back and forth between an object being
	inspected and the object's delegate.  The intent of this arrangement was to
	allow a single inspector panel and a manager type object that serves
	as the inspected objects delegate to handle any number of inspected objects.
	This arrangement does not require the inspected objects to know about the
	inspector panel objects or the instance methods that update their state.  */
#import <objc/Object.h>

@interface InspectorInfo : Object
{
	// Add instance variables in subclass for the values if desired
}

/*\ ----------- Methods to Override ----------- \*/
	// Return a symbolic name for the information contained by the object
- (const char *) infoName;
	// Return a numeric code for the information contained by the object
- (int) infoCode;
	/* Return a string description for the value contained by the object.  It is
		a comma delimited string of value descriptions equivalent to the
		Storage object description string semantics */
- (const char *) valueDescription;
	/* This method returns the value contained by the object.  Each argument
		following the valueDescription string corresponds to an element of
		the valueDescription string. */
- infoValue:(const char *) valueDescription, ...;
	/* These two methods test for equality of InspectorInfo objects. The
		fastIsEqual method can assume that the otherInfo argument is the same
		class as the receiving object. */
- (BOOL) isEqual: otherInfo;
- (BOOL) fastIsEqual: otherInfo;

@end

/* A formal protocol that must be implemented by the inspected object and the
	object's delegate in order to interact with the inspector panel */
@protocol InspectorInfoUpdate
- (BOOL) updateWithInspectorInfo:(InspectorInfo *) theInfo;
- (BOOL) getInspectorInfo: theInfo;
@end
/* RCS Information:
	$Author: me $;
	$Date: 94/01/08 14:40:33 $;
	$Source: /usr1/me/NeXTSrc/Archie/RCS/InspectorInfo.h,v $;
	$Revision: 1.1 $;
	$Log:	InspectorInfo.h,v $
 * Revision 1.1  94/01/08  14:40:33  me
 * Check point of 2.09a version.
 * 
 * Revision 1.1  93/03/29  01:59:48  me
 * Added to support the file inspector panel.
 * ;
*/
