/* A File subclass used to represent files available from remote
	hosts via anonymous ftp */
#import "File.h"
#import "ftplib.h"	// Contains FTPInfoPtr declaration

typedef struct ListingEntry
{
	char mode[10];	// UNIX file mode
	int size;		// File size in bytes
	int month;		// Month [1-12]
	int day;			// Day of month [1-31]
	int year;		// Year > 1900
	int hr;			// Hour [0-59]
	int min;			// Minute [0-59]
	char *name;		// Name of file. Terminated by either '\n' or '\0' 
} ListingEntry;

@interface FtpFile : File
{
	FTPInfoPtr ftpInfo;	// A struct containing the ftp information
}

- ftpInit:(const ListingEntry *) listingEntry host:(const char *) ftpHost
	parentDir:(const char *) path info:(FTPInfoPtr) info;
- setFTPInfo:(FTPInfoPtr) info;
- ftpLoadDir: sender;
- dirListing:(const char *) pathname ftpd: ftpd;
- resolveLink:(const char *) targetName ftpd: ftpd;

@end
/* RCS Information:
	$Author: me $;
	$Date: 94/01/08 14:40:20 $;
	$Revision: 1.1 $;
*/
