/* FileWellView is a View subclass that conforms to the
	NXDraggingSource protocol. It provides a visual representation
	of the three most common types of file selections one
	sees in a browser -- document, folder, and multiple.
	As an NXDraggingSource, one can drag the image over
	NXDraggingDestinations that accept the NXFilenamePboardType
	of data we provide.  We require a delegate that implements our
	provideSrcData: delegate method. We provide NX_DragOperationGeneric,
	NX_DragOperationCopy, and NX_DragOperationLink operations. */
#import <appkit/View.h>

typedef enum {eDocumentSelection, eFolderSelection, eMultipleSelection,
	N_Images} SelectionType;

@interface FileWellView : View
{
	id currentImage;	// The current selection image to display
	id delegate;		// Our source delegate
	BOOL provideData;	// A flag indicating if we should provide pasteboard data
}

/*\ ---------------------- Initialization Methods ---------------------- \*/
+ initialize;
- setDelegate: srcDelegate;

/*\ ---------------- NXDraggingSource Protocol Methods ---------------- \*/
- draggedImage:(NXImage *) image beganAt:(NXPoint *) screenPoint;
- draggedImage:(NXImage *) image endedAt:(NXPoint *) screenPoint
	deposited:(BOOL) flag;
- (NXDragOperation) draggingSourceOperationMaskForLocal:(BOOL) flag;
/* Related methods */
- mouseDown:(NXEvent *) theEvent;
- (BOOL) shouldDelayWindowOrderingForEvent:(NXEvent *) theEvent;

/*\ ---------------------- Drawing Methods ---------------------- \*/
- clear;
- drawSelf:(const NXRect *)rects :(int) rectCount;
- showImage:(SelectionType) type;

/*\ ---------------------- Pasteboard Methods ---------------------- \*/
- pasteboard: sender provideData:(NXAtom) type;

@end

/*\ ---------------------- Delegate Methods ---------------------- \*/
@interface Object(FileWellViewDelegate)
- (NXStream *) provideSrcData:(NXAtom) type;
@end

/*\ -------------------- Error & Debugging Categories -------------------- \*/
#import "errMessages.keys"
#import "appMessages.keys"
#import "Object_AllocNDebug.h"

/* RCS Information:
	$Author: me $;
	$Date: 94/01/08 14:40:15 $;
	$Source: /usr1/me/NeXTSrc/Archie/RCS/FileWellView.h,v $;
	$Revision: 1.1 $;
	$Log:	FileWellView.h,v $
 * Revision 1.1  94/01/08  14:40:15  me
 * Check point of 2.09a version.
 * 
 * Revision 1.1  93/02/23  02:10:10  me
 * Version 2.01a of the project.
 * ;
*/
