#import "FileInspectorInfo.h"

@implementation DirectorySortKey

- (const char *) infoName
{
	return "DirectorySortKey";
}

- (int) infoCode
{
	return eDirectorySortKey;
}

- (const char *) valueDescription
{
	return "i";
}

- setValue:(SortKeyEnum) _sortKey
{
	sortKey = _sortKey;

	return self;
} // End setValue:

- takeValueFrom: otherInfo
{
SortKeyEnum _sortKey;

	[otherInfo infoValue: [self valueDescription], &_sortKey];
	[self setValue: _sortKey];

	return self;
}

- infoValue:(const char *) valueDescription, ...
{
va_list args;
SortKeyEnum *sortKeyValue;

	if( strcmp(valueDescription, [self valueDescription]) != 0 )
		return nil;

	va_start(args, valueDescription);
	sortKeyValue = va_arg(args, int *);
	*sortKeyValue = sortKey;
	va_end(args);

	return self;
}

- (SortKeyEnum) sortKey
{
	return sortKey;
}

- (BOOL) fastIsEqual: otherInfo
{
SortKeyEnum _sortKey;

	[otherInfo infoValue: [self valueDescription], &_sortKey];
	if( _sortKey != sortKey )
		return NO;
	return YES;
}

@end

@implementation FileInfo

- (const char *) infoName
{
	return "FileInfo";
}

- (int) infoCode
{
	return eFileInfo;
}

- (const char *) valueDescription
{
	return "*, i, *, *, *, i";
}

- setValue:(char *) _fileMode :(int) _fileSize :(NXAtom) _sourceHost :(char *) _sourcePath
	:(char *) _localPath :(FileType) _type
{
	fileMode = _fileMode;
	fileSize = _fileSize;
	sourceHost = _sourceHost;
	sourcePath = _sourcePath;
	localPath = _localPath;
	type = _type;

	return self;
}

- takeValueFrom: otherInfo
{
int _fileSize;
FileType _type;
char *_fileMode, *_sourceHost, *_sourcePath, *_localPath;

	[otherInfo infoValue: [self valueDescription], &_fileMode, &_fileSize, &_sourceHost,
		&_sourcePath, &_localPath, &_type];
	[self setValue: _fileMode : _fileSize : _sourceHost : _sourcePath : _localPath : _type];

	return self;
}

- infoValue:(const char *) valueDescription, ...
{
va_list args;
int *_fileSize;
FileType *_type;
char **_fileMode, **_sourceHost, **_sourcePath, **_localPath;


	if( strcmp(valueDescription, [self valueDescription]) != 0 )
		return nil;

	va_start(args, valueDescription);
	_fileMode = va_arg(args, char **);
	*_fileMode = fileMode;
	_fileSize = va_arg(args, int *);
	*_fileSize = fileSize;
	_sourceHost = va_arg(args, char **);
	*_sourceHost = sourceHost;
	_sourcePath = va_arg(args, char **);
	*_sourcePath = sourcePath;
	_localPath = va_arg(args, char **);
	*_localPath = localPath;
	_type = va_arg(args, int *);
	*_type = type;
	va_end(args);

	return self;
}

- (const char *) fileMode
{
	return fileMode;
}
- (int) fileSize
{
	return fileSize;
}
- (const char *) sourceHost
{
	return sourceHost;
}
- (const char *) sourcePath
{
	return sourcePath;
}
- (const char *) localPath
{
	return localPath;
}
- (FileType) type
{
	return type;
}

- (BOOL) fastIsEqual: otherInfo
{
int _fileSize;
FileType _type;
char *_fileMode, *_sourceHost, *_sourcePath, *_localPath;

	[otherInfo infoValue: [self valueDescription], &_fileMode, &_fileSize, &_sourceHost,
		&_sourcePath, &_localPath, &_type];
	if( _type != type )
		return NO;
	else if( _fileSize != fileSize )
		return NO;
	else if( _sourceHost != sourceHost )	// We can do this because it is really an NXAtom
		return NO;
	else if( strcmp(_sourcePath, sourcePath) != 0 )
		return NO;
	else if( strcmp(_localPath, localPath) != 0 )
		return NO;

	return YES;
}

@end
/* RCS Information:
	$Author: me $;
	$Date: 94/01/08 14:40:12 $;
	$Source: /usr1/me/NeXTSrc/Archie/RCS/FileInspectorInfo.m,v $;
	$Revision: 1.1 $;
	$Log:	FileInspectorInfo.m,v $
Revision 1.1  94/01/08  14:40:12  me
Check point of 2.09a version.

Revision 1.1  93/03/29  01:55:07  me
Contains support for File attributes and contents inspector panels.
;
*/
