/* InspectorInfo subclasses for File object information */
#import "InspectorInfo.h"
#import <objc/hashtable.h>

/*\ ---------------------------------- Inspector Panel Defines ---------------------------------- \*/
/* The names of the objects in the inspector panel in FileInspector.nib */
#define SOURCE_FILENAME_FIELD	"SourceFilenameField"
#define FILE_ICON_VIEW			"FileIconView"
#define SOURCE_PATH_FIELD		"SourceFilePathField"

/* The names of the objects in the 'attributes' inspector panel view in FileInfo.nib */
#define ATTRIBUTES_WINDOW		"FileAttributesWindow"
#define FILE_INFO_BOXVIEW		"FileInfoBoxView"
#define SOURCE_HOST_FIELD		"SourceHostnameField"
#define LOCAL_FILENAME_FIELD	"LocalFileNameField"

/* The names of the objects in the 'contents' inspector panel view in FileContents.nib */
#define CONTENTS_WINDOW		"FileContentsWindow"
#define DIR_SORT_BOXVIEW		"DirSortBoxView"
#define DIR_SORT_MATRIX		"DirSortMatrix"

/* enums for the inspector groups */
enum {eAttributesGroup, eContentsGroup} InspectorGroup;
/* enums for the infoCode values of the subclasses */
enum {eDirectorySortKey, eFileInfo} FileInspectorInfoCodes;

/*\ ------------ DirectorySortKey Class ------------ \*/
/* The possible sort keys.  The enum values correspond to the rows of
	the matrix object in the contents inspector panel. */
typedef enum {eSortByName, eSortByInvName, eSortByDate, eSortByInvDate,
	eSortBySize, eSortByInvSize} SortKeyEnum;
@interface DirectorySortKey : InspectorInfo
{
	SortKeyEnum sortKey;
}

- (const char *) infoName;
- (int) infoCode;
- (const char *) valueDescription;
- setValue:(SortKeyEnum) _sortKey;
- takeValueFrom: otherInfo;
- infoValue:(const char *) valueDescription, ...;
- (SortKeyEnum) sortKey;
- (BOOL) fastIsEqual: otherInfo;
@end

/*\ ------------ FileInfo Class ------------ \*/
/* File type enums */
typedef enum {eRegularFile, eDirectoryFile, eLinkFile} FileType;
@interface FileInfo : InspectorInfo
{
	char *fileMode;		// UNIX style file mode
	int fileSize;			// File size in bytes
	NXAtom sourceHost;	// Host from which the file orginated
	char *sourcePath;		// Full pathname of the file on sourceHost
	char *localPath;		// Full pathname of the file on local host
	FileType type;			// The type of file
}

- (const char *) infoName;
- (int) infoCode;
- (const char *) valueDescription;
- setValue:(char *) _fileMode :(int) _fileSize :(NXAtom) _sourceHost
	:(char *) _sourcePath :(char *) _localPath :(FileType) _type;
- takeValueFrom: otherInfo;
- infoValue:(const char *) valueDescription, ...;
- (const char *) fileMode;
- (int) fileSize;
- (const char *) sourceHost;
- (const char *) sourcePath;
- (const char *) localPath;
- (FileType) type;
- (BOOL) fastIsEqual: otherInfo;

@end
/* RCS Information:
	$Author: me $;
	$Date: 94/01/08 14:40:09 $;
	$Revision: 1.1 $;
*/
