/* This is the beginnings of an abstract class which provides a object
	interface for tasks associated with files. It is a subclass of
	my Date class. */
#import <Date.h>
#import <objc/hashtable.h>	// NXAtom type
#import "InspectorInfo.h"	// Defines InspectorInfo class and InspectorInfoUpdate protocol
#import "FileInspectorInfo.h"	// Defines the InspectorInfo attributes we handle

@class ObjectList;

@interface File : Date <InspectorInfoUpdate>
{
	char fileMode[11];		// UNIX style file mode
	int fileSize;			// File size in bytes
	NXAtom sourceHost;		// Host from which the file orginated
	char *sourcePath;		// Full pathname of the file on sourceHost
	char *localPath;		// Full pathname of the file on local host
	char *pathString;		// String set by methods that parse the full pathname
	id delegate;			// An object which can perform ops for us
		// An InspectorInfo subclass used to interact with the info inspector panel
	FileInfo *fileInfo;
	FileType fileType;

	/* Additional info for directories & links */
		// An ObjectList of File objects for the directory
	ObjectList <ObjectArchival> *listing;
		// A flag indicating if listing is being loaded
	BOOL dirLoading;
		// A flag indicating if a previous load attempt failed to find any files
	BOOL emptyDir;
		// A File object for the link target if isLink == YES
	File *linkTarget;
		// An InspectorInfo subclass used to interact with the sort key inspector panel
	DirectorySortKey *sortKey;
}

/*\ ----------------------- Initialization Methods ----------------------- \*/
- init:(const char *) filename mode:(const char *) mode size:(int) size;
- init:(const char *) filename mode:(const char *) mode size:(int) size
	day:(int) day month:(int) month year:(int) year hour:(int) hour
	min:(int) min;

- setSourceHost:(const char *) host;
- setDelegate: theDelegate;
- loadDirectory: server;
- setDirLoading:(BOOL) flag;
- setEmptyDir:(BOOL) flag;
- setLinkTarget: target;

/*\ ----------------------- Info Methods ----------------------- \*/
- (const char *) localName;
- (const char *) sourceName;
- (const char *) sourceNameWithLink;
- (const char *) localPathname;
- (const char *) sourcePathname;
- (const char *) localDirectory;
- (const char *) sourceDirectory;
- (NXAtom) sourceHost;
- (const char *) modeString;
- (int) mode;
- (BOOL) isDirectory;
- (BOOL) isLink;
- (BOOL) isLocal;
- (int) fileSize;
- dirListing;
- (BOOL) dirLoading;
- (BOOL) emptyDir;
- linkTarget;
- (DirectorySortKey *) sortKey;
- (const char *) linkTargetName:(BOOL) getFullPath;
- fileFromPath:(const char *) subPath;

/*\ --------------------- Local Manipulation Methods --------------------- \*/
- (const char *) verifyPathname:(const char *) pathname
	collisionWarnings:(BOOL) collisionWarnings;
- createLocalFile:(NXStream *) stream path:(const char *) pathname
	collisionWarnings:(BOOL) collisionWarnings;
- copyFileTo:(const char *) targetPathname collisionWarnings:(BOOL) collisionWarnings;
- moveFileTo:(const char *) targetPathname collisionWarnings:(BOOL) collisionWarnings;
- linkFileTo:(const char *) targetPathname collisionWarnings:(BOOL) collisionWarnings;
- deleteFile:(BOOL) prompt;
- recycleFile;

/*\ ---------------------- Display Methods ---------------------- \*/
- (BOOL) openInWorkspace;

/*\ ------------------ ObjectArchival Protocol Methods ------------------ \*/
#define FILE_VERS		1	// Object release version
#define FILE_SUBVERS	1	// Object subrelease version
#define FILE_TYPE		0	// Object version type
/* Object versions we know about */
#define FILE_VERSION_0 1000
#define FILE_VERSION_1 1010

- readFromTStream:(NXTypedStream *) stream;	// Override
- writeToTStream:(NXTypedStream *) stream;	// Override

/*\ ------------- InspectorInfo Protocol & Related Methods ------------- \*/
- (BOOL) updateWithInspectorInfo:(InspectorInfo *) theInfo;
- (BOOL) getInspectorInfo: theInfo;

@end

/*\ ------------------- Informal FileDelegate Protocol ------------------- \*/
@interface Object(FileDelegate)
- (const char *) createLocalFile: theFile;
@end

/*\ ----------------------- Constants ----------------------- \*/
extern NXAtom LocalHost;

/* RCS Information:
	$Author: me $;
	$Date: 94/01/08 14:40:02 $;
	$Source: /usr1/me/NeXTSrc/Archie/RCS/File.h,v $;
	$Revision: 1.1 $;
	$Log:	File.h,v $
 * Revision 1.1  94/01/08  14:40:02  me
 * Check point of 2.09a version.
 * 
 * Revision 1.3  93/03/29  01:54:05  me
 * Updated for file inspection and updated the archival methods to read and write ObjectLists rather than Lists.
 * 
 * Revision 1.2  93/02/24  18:35:02  me
 * Added an emptyDir flag for marking directories with no files.
 * 
 * Revision 1.1  93/02/23  02:09:55  me
 * Version 2.01a of the project.
 * ;
*/
