{\rtf0\ansi{\fonttbl\f0\fmodern Courier;}
\paperw11760
\paperh7140
\margl120
\margr120
{\colortbl;\red0\green0\blue0;}
\pard\tx520\tx1060\tx1600\tx2120\tx2660\tx3200\tx3720\tx4260\tx4800\tx5320\f0\b\i0\ulnone\fs24\fc0\cf0 #ifndef FTPObject_H\
#define FTPObject_H\
/* An Object subclass which provides access to remote ftpd servers. In\
	its  interactive mode it manages a panel that gives a browser interface\
	to the remote ftp file heirarchy similar to the Workspace browser. */\
\
#import <objc/Object.h>\
#import <appkit/Application.h>	
\b0\fs20 // NXModalSession declaration
\b\fs24 \

\pard\tx480\tx960\tx1440\tx1920\tx2400\tx2880\tx3360\tx3840\tx4320\tx4800\fc0\cf0 #import <ObjectList.h>		
\b0\fs20\fc1\cf1 // Sorted List object declaration
\b\fs24\fc0\cf0 \

\pard\tx520\tx1060\tx1600\tx2120\tx2660\tx3200\tx3720\tx4260\tx4800\tx5320\fc0\cf0 #import "InspectorInfo.h"	
\b0\fs20\fc1\cf1 // Defines InspectorInfo class and InspectorInfoUpdate protocol
\b\fs24\fc0\cf0 \
#import "FileInspectorInfo.h"	
\b0\fs20\fc1\cf1 // Defines the InspectorInfo attributes we handle
\b\fs24\fc0\cf0 \
#import "ftplib.h"		
\b0\fs20\fc1\cf1 // FTPInfoPtr declaration
\b\fs24\fc0\cf0 \
#import <mach/cthreads.h>\
\
@class FtpFile, MenuCell;\
\
@interface FTPObject : Object\
\{\
	/* Outlets to the FTP Status panel */\
	id statusPanelID;	
\b0\fs20\fc1\cf1 // The progress Panel
\b\fs24\fc0\cf0 \
	id hostnameID;		
\b0\fs20\fc1\cf1 // A TextField for the ftp hostname
\b\fs24\fc0\cf0 \
	id bytesTransferredID;	
\b0\fs20\fc1\cf1 // A TextField for the bytes transferred
\b\fs24\fc0\cf0 \
	id percentID;		
\b0\fs20\fc1\cf1 // The PercentView for the transfer status
\b\fs24\fc0\cf0 \
	id msgID;			
\b0\fs20\fc1\cf1 // A TextField for a status message
\b\fs24\fc0\cf0 \
	id filenameID;		
\b0\fs20\fc1\cf1 // A TextField for the filename
\b\fs24\fc0\cf0 \
	id clockViewID;	
\b0\fs20\fc1\cf1 // The ClockView for the time
\b\fs24\fc0\cf0 \
\
	/* Outlets to the FTP log console panel */\
	id logPanelID;		
\b0\fs20\fc1\cf1 // The Panel object
\b\fs24\fc0\cf0 \
	id ftpLogID;		
\b0\fs20\fc1\cf1 // A TextConsole object
\b\fs24\fc0\cf0 \
\
	/* General FTP session variables */\
	id ftpLoginPanelID;	
\b0\fs20\fc1\cf1 // A panel for the ftp login info
\b\fs24\fc0\cf0 \
	id loginHostnameID;	
\b0\fs20\fc1\cf1 // The hostname TextField
\b\fs24\fc0\cf0 \
	id loginUsernameID;	
\b0\fs20\fc1\cf1 // The username TextField
\b\fs24\fc0\cf0 \
	id loginPasswdID;		
\b0\fs20\fc1\cf1 // The password TextField
\b\fs24\fc0\cf0 \
	id visiblePasswdID;	
\b0\fs20\fc1\cf1 // The visible password Button
\b\fs24\fc0\cf0 \
	id netrcStringID;		
\b0\fs20\fc1\cf1 // A string displayed if fields were filled from a .netrc file
\b\fs24\fc0\cf0 \
\
	/* Outlets used with the interactive window  */\
	id ftpWindowID;	
\b0\fs20\fc1\cf1 // The interactive ftp Window
\b\fs24\fc0\cf0 \
	id fileBrowserID;	
\b0\fs20\fc1\cf1 // The NXBrowser used to display the remote files
\b\fs24\fc0\cf0 \
	id fileInfoID;		
\b0\fs20\fc1\cf1 // The file info Form
\b\fs24\fc0\cf0 \
	id calViewID;		
\b0\fs20\fc1\cf1 // The CalendarView for the date
\b\fs24\fc0\cf0 \
	id fileWellID;		
\b0\fs20\fc1\cf1 // The FileWellView for diplaying the selection
\b\fs24\fc0\cf0 \
	id statusMsgID;
\b0\fs20\fc1\cf1 	// The status msg TextField
\b\fs24\fc0\cf0 \
\
	/* General instance variables */\
	FtpFile *rootDir;			
\b0\fs20\fc1\cf1 // FtpFile object for the ftpHost's top directory
\b\fs24\fc0\cf0 \
	ObjectList *orphanDirs;	
\b0\fs20\fc1\cf1 // FtpFile directories that have been loaded\
								//	during link resolution but don't have their\
								//	parent in the rootDir heirarchy yet
\b\fs24\fc0\cf0 \
	List *activePathNodes;		
\b0\fs20\fc1\cf1 // The List of Files for the currently selected branch
\b\fs24\fc0\cf0 \
	List *selectionList;		
\b0\fs20\fc1\cf1 // The List of selected cells in the file browser
\b\fs24\fc0\cf0 \
	id preferences;			
\b0\fs20\fc1\cf1 // A reference to the app Prefences object
\b\fs24\fc0\cf0 \
	char *ftpHost;				
\b0\fs20\fc1\cf1 // The current ftp host
\b\fs24\fc0\cf0 \
	const char *currentDirectory;	
\b0\fs20\fc1\cf1 // The current ftp directory
\b\fs24\fc0\cf0 \
	FTPInfoPtr ftpInfo;		
\b0\fs20\fc1\cf1 // The info required by the ftplib.c routines
\b\fs24\fc0\cf0 \
	char *loginDirectory;		
\b0\fs20\fc1\cf1 // The directory at login
\b\fs24\fc0\cf0 \
	char *localTransferDir;	
\b0\fs20\fc1\cf1 // The location for depositing files
\b\fs24\fc0\cf0 \
	char *currentSubDir;	
\b0\fs20\fc1\cf1 // The location relative to localTransferDir for
\b\fs24\fc0\cf0 \
							
\b0\fs20\fc1\cf1 // 	the current sub directory retrieval
\b\fs24\fc0\cf0 \
	BOOL isInteractive;	
\b0\fs20\fc1\cf1 // A flag indicating if this is an interactive session
\b\fs24\fc0\cf0 \
	NXModalSession *ftpSession;\
	struct FileTransferInfo\
	\{	
\b0\fs20\fc1\cf1 // File transfer information used by transfer thread
\b\fs24\fc0\cf0 \

\fc1\cf1 		cthread_t transferThread;	
\b0\fs20 // File transfer thread
\b\fs24 \

\fc0\cf0 		FTPObject *ftpd;			
\b0\fs20\fc1\cf1 // FTPObject sed by cthread function
\b\fs24\fc0\cf0 \
		NXStream *fileStream;		
\b0\fs20\fc1\cf1 // Memory stream the file is transfered to
\b\fs24\fc0\cf0 \
		long bytesTransferred;		
\b0\fs20\fc1\cf1 // Transfer byte count
\b\fs24\fc0\cf0 \
		BOOL abort;		
\b0\fs20\fc1\cf1 // Has an abort: message been sent to main thread
\b\fs24\fc0\cf0 \
		BOOL done;		
\b0\fs20\fc1\cf1 // Is the transfer complete
\b\fs24\fc0\cf0 \
	\} transferInfo;\
	/*  Instance variables required by the FTPObject(Inspector) category.\
		I need to create a new superclass to implement this properly. */\
	id fileInspector;\
	id inspectedFile;\
	FileInfo *fileInfo;\
	int inspectorGroup;\
	DirectorySortKey *sortKey;\
		// Inspector panel outlets\
	id sourceNameID;\
	id sourcePathID;\
	id fileIconID;\
	id sourceHostID;\
	id localPathID;\
	id sortMatrixID;\
\
\}\
\

\b0\fs28\fc1\cf1 /*\\ ------------- Class Methods ------------- \\*/\

\b\fs24 + (BOOL) userIsAnonymous:(const char *) username;\
\

\b0\fs28 /*\\ ------------- Initialization Methods ------------- \\*/
\b\fs24\fc0\cf0 \
- init;\
- initForHost:(const char *) host interactive:(BOOL) interactive\
	initialPath:(const char *) initialPath;\
- initForGeneralLogin;\
- initForGeneralLogin:(const char *) hostname\
	initialPath:(const char *) initialPath;\
- free;\
\

\b0\fs28\fc1\cf1 /*\\ ------------- FTP Session Methods ------------- \\*/
\b\fs24\fc0\cf0 \
- abort: sender;\
- doLogin: sender;\
- login:(const char *) hostname interactive:(BOOL) interactive\
	initialPath:(const char *) initialPath;\
- login:(const char *) hostname user:(const char *) username\
	passwd:(const char *) passwd interactive:(BOOL) interactive\
	initialPath:(const char *) initialPath;\
- logout : sender;\
- (NXStream *) retrieveFiles: fileList;\
- setTransferDir: sender;\
- setLocalTransferDir:(const char *) transferDir;\
- (NXStream *) streamForCmd:(const char *) command :(const char *) arg;\
- fileFromPath:(const char *) path;\
- addOrphanDir:(FtpFile *) ftpDir;\
- removeOrphanDir:(const char *) path;\
\

\b0\fs28\fc1\cf1 /*\\ ------------- FTP Action Methods ------------- \\*/
\b\fs24\fc0\cf0 \
- openInWorkspace: sender;\
- retrieve: sender;\
- showFTPLog: sender;\
- showFTPStatus: sender;\

\fc1\cf1 - clearStatusMsg: ignored;\

\fc0\cf0 \

\b0\fs28\fc1\cf1 /*\\ ------------- File Delegate Methods ------------- \\*/
\b\fs24\fc0\cf0 \
- incSubDirPath:(const char *) newDir;\
- decSubDirPath;\
- (const char *) createLocalFile: theFile;\
\

\b0\fs28\fc1\cf1 /*\\ ------------- Browser Delegate Methods ------------- \\*/
\b\fs24\fc0\cf0 \
- (int) browser: sender getNumRowsInColumn:(int) column;\
- browser: sender loadCell: cell atRow:(int) row inColumn:(int) column;\
- displaySelection: sender;\
\

\b0\fs28\fc1\cf1 /*\\ ------------- Window Delegate Methods ------------- \\*/
\b\fs24\fc0\cf0 \
- windowWillClose: sender;\
\

\b0\fs28\fc1\cf1 /*\\ ------------- Menu Update Methods ------------- \\*/
\b\fs24\fc0\cf0 \
- (BOOL) validateCommand:(MenuCell *) menuCell;\
\

\b0\fs28\fc1\cf1 /*\\ ------------- Text Delegate Methods ------------- \\*/
\b\fs24\fc0\cf0 \

\fc1\cf1 - (BOOL) textWillEnd: textObject;\

\b0\i\fs28 \
/*\\ ----------- FileWellView Delegate Methods ----------- \\*/
\b\i0\fs24\fc0\cf0 \
- (NXStream *) provideSrcData:(NXAtom) type;\
@end\
\

\b0\fs28\fc1\cf1 /*\\ ------ InspectorInfo Protocol & Related Methods ------ \\*/
\b\fs24\fc0\cf0 \
@interface FTPObject(Inspector) <InspectorInfoUpdate>\
- (BOOL) updateWithInspectorInfo:(InspectorInfo *) theInfo;\
- (BOOL) getInspectorInfo: theInfo;\
- inspectorIsActive: inspector;\
- inspectObject: theObject msg:(const char *) theMsg;\
	// InspectorManager delegate methods & panel object action methods\
- groupChanged: sender to: (int) newGroup;\
- inspectRevert: sender;\
- inspectOK: sender;\
- setSortKey: sender;\
@end\
\

\b0\fs28\fc1\cf1 /*\\ ------------- FTPD Category Methods ------------- \\*/
\b\fs24\fc0\cf0 \
@interface Object(FTPDaemon)\
- (FTPInfoPtr) ftpOpen:(const char *) hostname textConsole: ftpConsole;\
- (FTPInfoPtr) ftpOpenAddress:(struct in_addr *) address\
	port:(unsigned short) port textConsole: ftpConsole;\
- ftpLogin:(FTPInfoPtr) info user:(char *) user passwd:(char *) passwd;\
- (int) ftpSendCmd:(FTPInfoPtr) info cmd:(char *) command arg:(char *) arg;\
- (int) ftpPort:(FTPInfoPtr) info;\
- (int) ftpOpenDataConn:(FTPInfoPtr) info cmd:(char *) command\
	arg:(char *) arg;\
- (int) ftpCloseDataConn:(FTPInfoPtr) info;\
- (int) ftpReadDataConn:(FTPInfoPtr) info buffer:(char *) buffer\
	length:(int) length;\
- ftpQuit:(FTPInfoPtr) info;\
- ftpClose:(FTPInfoPtr) info;\
- (int) ftpAbort:(FTPInfoPtr) info;\
- (int) ftpCwd:(FTPInfoPtr) info newDir:(char *) directory;\
- (const char *) ftpPwd:(FTPInfoPtr) info;\
- (int) ftpType:(FTPInfoPtr) info type:(char *) type;\
- (int) ftpReplyCode:(FTPInfoPtr) info;\
- ftpError:(FTPInfoPtr) info;\
@end\
\

\b0\fs28\fc1\cf1 /*\\ ------------- Exceptions ------------- \\*/
\b\fs24\fc0\cf0 \
#import "ObjectArchival.h"\
enum \{eRtnMemoryErr = END_ObjectArchival_EXCEPTIONS, eNoFtpHost, eCWDFailure,\
	eOpenFailure, eNoListing, eNoFileEntry, eRetreiveErr, eFileMemoryErr,\
	eSaveFileErr, eFTPAbort, END_FTPObject_EXCEPTIONS\};\
\

\b0\fs28\fc1\cf1 /*\\ ------------ Error & Debugging Categories ------------ \\*/
\b\fs24\fc0\cf0 \
#import "Object_AllocNDebug.h"\
\
/* RCS Information:\
	$Author: me $;\
	$Date: 94/01/08 14:40:26 $;\
	$Source: /usr1/me/NeXTSrc/Archie/RCS/FTPObject.h,v $;\
	$Revision: 1.1 $;\
	$Log:	FTPObject.h,v $\
 * Revision 1.1  94/01/08  14:40:26  me\
 * Check point of 2.09a version.\
 * \
 * Revision 1.3  93/03/29  01:58:44  me\
 * Fixed problem that would not allow ftp transfers when we were launched as a service.  Updated to act as the file inspector delegate for the new inspector panel.\
 * \
 * Revision 1.2  93/03/02  15:54:32  me\
 * Added outlet for visible password button.\
 * \
 * Revision 1.1  93/02/23  02:10:37  me\
 * Version 2.01a of the project.\
 * ;\
*/\
\
#endif	// FTPObject_H\

}
