/* An Objective-C class that manages an ArchieSession document. */
#ifndef ARCHIE_SESSION_H
#define ARCHIE_SESSION_H

#import <objc/Object.h>
#import <ObjectArchival.h>

@class List;

@interface ArchieSession : Object <ObjectArchival>
{
	/* Outlets to the main nib file */
	id windowID;		// The session window
	id fileBrowserID;	// The Browser which display the server responses
	id queryFieldID;	// The query TextField
	id queryBtnID;		// The query Button
	id fileInfoID;		// File info Form
	id readMatrixID;	// Permission matrices
	id writeMatrixID;
	id execMatrixID;
	id calendarID;		// The CalendarView object
	id clockID;			// The ClockView object
	id selectionViewID;	// The FileWellView object
	id nextBtnID;		// Button for displaying next query in the browser
	id prevBtnID;		// Button for displaying previous query in the browser
	id queryNoID;		// The field holding the current query number
	id queryCountID;	// The field which holds the total query count
	id matchCountID;	// The field holding the current query match count
	id smallMsgID;	// A small msg field

	/* Ftp stuff */
	id ftpObject;		// The FTPObject which handles ftp transfer
	id modeMatrixID;	// The file transfer mode Matrix
	id retrieveBtnID;	// The Retrieve Button in the main window
	id selectedFile;	// The PVlink for the file selected in the browser

	/* Query variables */
	List <ObjectArchival> *queryList;	// A List of queries made this session
	id viewQuery;		// The Query object associated with the browser
	int viewQueryIndex;	// The index into queryList of viewQuery
	int activeQueryCount;	// The number of queries waiting for responses

	/* Document variables */
	char *documentPath;	// The full pathname of the doc
	char *documentName;	// The last component of the doc path
	BOOL isUntitled;	// YES if doc was created by +new and never saved

	/* Pasteboard variables */
	int pbChangeCount;	// The Pasteboard change count prior to last op
	id pbQuery;			// The query object that supplied the Pasteboard data
	id lastDeletedQuery;	// The last deleted query object

	/* The application Preferences object */
	id preferences;
}

/*\ ---------------------- Initialization Methods ---------------------- \*/
+ new;
+ newFromFile;
+ newFromFile: (const char *) filename;
- init;
- awakeFromNib;

/*\ ---------------------- Document Methods ---------------------- \*/
+ (BOOL) canOpenFileType:(const char *) aType;
- save: sender;
- saveAs: sender;
- close: sender;
- (BOOL) isEdited;

/*\ ---------------------- Query Methods ---------------------- \*/

/* Archie server request method */
- archieRequest: sender;
- displayQuery: sender;

/* Parsing and displaying the Archie server response */
- clearFields;
- nextQuery: sender;
- prevQuery: sender;

/*\ ---------------------- Window Object Access ---------------------- \*/
- getMainWindowID;
- getFileBrowserID;
- getQueryFieldID;
- getFileInfoID;
- getReadMatrixID;
- getWriteMatrixID;
- getExecMatrixID;
- getCalendarID;
- getClockID;
- getSelectionViewID;
- getSmallMsgID;

/*\ ---------------------- Menu Update Methods ---------------------- \*/
- (BOOL)validateCommand: menuCell;

/*\ ------------------- ObjectArchival Protocol Methods ------------------- \*/
/* The current version for new documents */
#define ARCHIESESSION_VERS		1	// Object release version
#define ARCHIESESSION_SUBVERS	0	// Object subrelease version
#define ARCHIESESSION_TYPE		0	// Object version type
/* Object versions we know about */
#define ARCHIESESSION_VERSION_0 1000

- initFromTStream:(NXTypedStream *) stream;
- readFromTStream:(NXTypedStream *) stream;
- writeToTStream:(NXTypedStream *) stream;

/*\ ---------------------- Edit Menu Actions ---------------------- \*/
- copy: sender;
- cut: sender;
- paste: sender;
- delete: sender;
- undelete: sender;

/*\ ---------------------------------- Service Methods ---------------------------------- \*/
- serviceArchieQuery: pasteboard userData:(const char *) serviceInfo
	error:(char **) errorMsg;

@end

/*\ -------------------- Error & Debugging Categories -------------------- \*/
#import "errMessages.keys"
#import "appMessages.keys"
#import "Object_AllocNDebug.h"
/*\ ---------------------- Document Category ---------------------- \*/
#import "Object_Document.h"

#endif	ARCHIE_SESSION_H
/* RCS Information:
	$Author: me $;
	$Date: 94/01/08 14:39:56 $;
	$Source: /usr1/me/NeXTSrc/Archie/RCS/ArchieSession.h,v $;
	$Revision: 1.1 $;
*/
