/* Simple ArchieServer class that creates a List of server
	objects for each entry in an NXStringTable */
#import <objc/Object.h>

@class List;

@interface ArchieServer : Object
{
	const char *serverName;
	const char *serverInfo;
	char serverDotAddr[16];
}

/*\ ------ Initializing/accessing instance list ------ \*/
+ initArchieServers: serverTable;
+ (List *) archieServers;
+ archieServerAt:(int) index;
+ archieServerFor:(const char *) name;

/*\ ------ Instance methods ------ \*/
- initForName:(const char *) name tableValue:(const char *) value;

- (const char *) serverName;
- (const char *) serverDotAddr;
- (const char *) serverInfo;

@end
