#include "archied.h"

static int active_socket;
void quit()
{
	close(active_socket);
	exit(0);
}

void main(int argc, char *argv[])
{
int rtn_val;
int request_socket, req_addr_len;
struct sockaddr_in server_addr;
VLINK vlink;
QueryRequest query;
void display_link (VLINK l);

	signal(SIGINT, quit);

	/* Open a TCP socket */
	request_socket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if( request_socket < 0 )
	{
		perror("Failed to open TCP socket for request");
		exit(1);
	}

	bzero(&server_addr, sizeof(server_addr));
	server_addr.sin_family = AF_INET;
	server_addr.sin_addr.s_addr = inet_addr("128.175.17.35");
	server_addr.sin_port = htons(SERV_PORT);
	rtn_val = connect(request_socket, (struct sockaddr *) &server_addr,
		sizeof(server_addr));
	if( rtn_val < 0 )
	{
		perror("Failed to connect to archied server");
		exit(2);
	}

	query.host = "archie.sura.net";
	query.qstring = "NeXT";
	query.max_hits = 5;
	query.query = 's';
	query.flags = 0;
	write_request(&query, request_socket);

	vlink = unarchive_vlink(request_socket);
	while( vlink != NULL )
	{
		display_link(vlink);
		vlink = vlink->next;
	}
}

/* Print the contents of the given virtual link.  */
void display_link (VLINK l)
{
PATTRIB 	ap;
char	linkpath[256];
int		dirflag = 0;
int		size = 0;
char	*modes = "";
char	archie_date[20];
char	*gt_date = "";
int		gt_year = 0;
int		gt_mon = 0;
int		gt_day = 0;
int		gt_hour = 0;
int		gt_min = 0;
int		special = 1;

	/* Initialize local buffers */
	*archie_date = '\0';

	/* Remember if we're looking at a directory */
	if ( strchr(l->type,"DIRECTORY") != NULL )
		dirflag = 1;
	else
		dirflag = 0;
    
	/* Extract the linkpath from the filename */
	strcpy(linkpath,l->filename);
	*(linkpath + (strlen(linkpath) - strlen(l->name) - 1)) = '\0';
    
	fprintf (stderr, "\nHost %s\n\n",l->host);
	fprintf (stderr,"\tLocation: %s\n",(*linkpath ? linkpath : "/"));
    
	/* Parse the attibutes of this link */
	for (ap = l->lattrib; ap; ap = ap->next)
	{
		if ( strcmp(ap->aname,"SIZE") == 0 )
						sscanf(ap->value.ascii,"%d",&size);
		else if( strcmp(ap->aname,"UNIX-MODES") == 0 )
						modes = ap->value.ascii;
		else if( strcmp(ap->aname,"LAST-MODIFIED") == 0 )
		{
			gt_date = ap->value.ascii;
			sscanf(gt_date,"%4d%2d%2d%2d%2d",&gt_year,&gt_mon,
				&gt_day, &gt_hour, &gt_min);
			sprintf(archie_date,"%s %2d %02d:%02d",month_sname(gt_mon),
				gt_day, gt_hour, gt_min);
		}
	}

	/* Print this link's information */
	fprintf (stderr,"      %9s %s %10d  %s  %s\n",
		(dirflag ? "DIRECTORY" : "FILE"), modes,size,archie_date,l->name);

}
