#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <pfs.h>
#include <archie.h>
#include <signal.h>

#define SERV_PORT 6000
#define NIL '\0'
#ifndef NULL
#	define NULL (void *) 0
#endif
#ifdef DEBUG
#	define D(x) x
#else
#	define D(x)
#endif

/* struct pattrib name attributes. I could not find these in the prospero includes
	so they are subject to becoming invalid. */
#define SIZE		"SIZE"
#define MODES	"UNIX-MODES"
#define DATE	"LAST-MODIFIED"

/* The query request record written by the client process */
typedef struct _QueryRequest {
	char *host;
	char *qstring;
	int max_hits;
	char query;
	int flags;
} QueryRequest, *QueryRequestPtr;

/* vlink_io prototypes */
int init_buffer_from_stream(int stream);
void check_bsize(int length);
void buffer_string(char *string);
void buffer_char(char c);
void buffer_int(int i);
void write_record(int request_socket);
void read_record(int request_socket);
void unbuffer_string(char **string);
void unbuffer_char(char *c);
void unbuffer_int(int *i);
void archive_vlink(VLINK vlink, int request_socket);
VLINK unarchive_vlink(int request_socket);
int write_request(QueryRequestPtr query, int request_socket);
int read_request(QueryRequestPtr query, int request_socket);

