/* A TCP based archie server */
#include "archied.h"

static int active_socket;
void quit()
{
	close(active_socket);
	exit(0);
}

void main(int argc, char *argv[])
{
int rtn_val;
int server_socket, request_socket, req_addr_len, request_pid;
struct sockaddr_in request_addr, server_addr;
void perform_query(int request_socket);

	signal(SIGINT, quit);

	/* Open a TCP socket */
	server_socket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if( server_socket < 0 )
	{
		perror("Failed to open TCP socket for archied");
		exit(1);
	}
	active_socket = server_socket;

	/* Bind our port number to the socket */
	bzero(&server_addr, sizeof(server_addr));
	server_addr.sin_family = AF_INET;
	server_addr.sin_addr.s_addr = htonl(INADDR_ANY);
	server_addr.sin_port = htons(SERV_PORT);
	rtn_val = bind(server_socket, (struct sockaddr *) &server_addr,
		sizeof(server_addr));
	if( rtn_val < 0 )
	{
		perror("Failed to bind port number for adrchied");
		exit(2);
	}

	/* Indicate we are ready to service requests on this port */
	listen(server_socket, 5);

	/* The server loop */
	while( 1 )
	{
		/* Accept a connection request */
		req_addr_len = sizeof(request_addr);
		request_socket = accept(server_socket, (struct sockaddr *) &request_addr,
			&req_addr_len);
D(fprintf(stderr, "Accepted connection...\n"));
		if( request_socket < 0 )
		{
			perror("archied: accept() error");
			exit(3);
		}

		/* Fork a process to service the request */
		request_pid = fork();
		if( request_pid < 0 )
		{
			perror("archied: failed to fork() request process");
			exit(4);
		}

		/* Child process performs the request */
		if( request_pid == 0 )
		{
			close(server_socket);
			perform_query(request_socket);
			exit(0);
		}

		/* Server closes the request socket */
		close(request_socket);
	} /* End server loop */

}

void perform_query(int request_socket)
{
VLINK vlink;
QueryRequest query;

D(fprintf(stderr, "\tPeforming query...\n"));
	/* Read the query request from the socket */
	read_request(&query, request_socket);

	/* Do the query */
	vlink = archie_query(query.host, query.qstring, query.max_hits, 0,
		query.query, AQ_INVDATECMP, query.flags);
D(fprintf(stderr, "\tCompleted query..."));

	/* Write the query response to the socket */
	archive_vlink(vlink, request_socket);
D(fprintf(stderr, "Done with request\n"));
} /* End perform_query() */
