/* The Archie application subclass.  It is responsible for document
	management and maintains application objects such as Preferences
	and error NXStringTables. */
#ifndef ArchieApp_H
#define ArchieApp_H
#import <appkit/Application.h>

@interface ArchieApp : Application
{
	id preferences;	// The application Preferences object
	id infoPanelID;	// The application info Panel
	id fileInspector;	// The application file inspector object
	id ftpHostsPanelID;	// The application FTP hosts Panel

	/* Other variables */
	id msgStringTable;	// An NXStringTable of the program error messages
	id errStringTable;	// An NXStringTable of the program error messages
	id imageBundle;	// The application images NXBundle
	id emptyDoc;		// An empty ArchieSession opens if user clickedx2 on app
	BOOL remoteLaunch;	// YES if a remote message launched us

	/* Stuff for the info panel animiation */
	struct _animInfo {
		int frameNum;
		enum DrawState {SendMsg, ProcessMsg, RecvMsg, DrawingDone} drawState;
		NXColor color;
		NXRect packet;
	} animInfo;
}

/*\ ---------------------- Document Menu Actions ---------------------- \*/
- new: sender;
- open: sender;
- saveAll: sender;

/*\ ----------------------- Panel Display Methods ----------------------- \*/
- infoPanel: sender;
- preferences: sender;
- mailScott: sender;
- whatIsArchie: sender;
- generalFTPLogin: sender;
- inspector: sender;
- showFTPLog: sender;

/*\ --------------------- App Value Access Methods --------------------- \*/
- imageBundle;
- preferences;
/* Return the application NXStringTable of error messages */
- errTable;
- msgTable;

/*\ ---------------------- App Delegate Methods ---------------------- \*/
- appDidInit: sender;
- appDidUnhide: sender;
- (BOOL)appAcceptsAnotherFile:sender;
- (int)app:sender openFile:(const char *)filename type:(const char *)aType;
- appWillTerminate: sender;

/*\ ---------------------- Menu Update Methods ---------------------- \*/
- (BOOL) menuItemUpdate: menuCell;
- (BOOL)validateCommand: menuCell;

/*\ ---------------------- Info Animation Methods ---------------------- \*/
- (BOOL) hasDrawMethodFor: image imageNum:(int) num;
- performDrawFor: image imageNum:(int) num inView: view;
- nextFrame;

/*\ ---------------------- Service Methods ---------------------- \*/
- serviceFtpToHost: pasteboard userData:(const char *) serviceInfo
	error:(char **) errorMsg;
- serviceArchieQuery: pasteboard userData:(const char *) serviceInfo
	error:(char **) errorMsg;
- validRequestorForSendType:(NXAtom) typeSent andReturnType:(NXAtom) typeReturned;

@end

/*\ -------------------- FTP Hosts Category -------------------- \*/
@interface ArchieApp(FTPHosts)
- ftpHosts: sender;
- newEntry: sender;
- updateEntry: sender;
- removeEntry: sender;
- doFTPLogin: sender;
- selectEntry: sender;
- (int)browser: sender  fillMatrix: matrix inColumn:(int) column;
- clearFields;
@end

/*\ -------------------- Error & Debugging Categories -------------------- \*/
#import "errMessages.keys"
#import "appMessages.keys"
#import "Object_AllocNDebug.h"

#endif // ArchieApp_H
/* RCS Information:
	$Author: me $;
	$Date: 94/01/08 14:39:44 $;
	$Revision: 1.1 $;
*/
