#!/bin/sh
REPQUOTA=`which repquota`
MESSAGE=/pfad/zu&message.txt
if test "" = "$REPQUOTA" ; then
	echo "repquota wurde nicht gefunden! Beende mich jetzt ..."
	exit 1
fi
# ermittelt die Benutzernamen, die von repquota ausgegeben werden (diese knnen krzer als die 
# richtigen Benutzernamen sein!)
USERS=`$REPQUOTA -a | awk '{print $1}' | grep -v ^root | grep -v ^User | grep -v ^Block | cut -b 1-10`
# Gibt die Benutzer aus:
for f in $USERS ; do 
	# ermittelt den echten Benutzernamen aus der /etc/passwd
	erg=`cat /etc/passwd | grep $f | awk -F: '{print $1}'`
	# ermittelt den benutzten Platz des Users
	USED=`$REPQUOTA -a | grep ^$f | awk '{print $3}'`
	# echo "USED: $USED"
	# ermittelt das Softlimit
	SOFTLIMIT=`$REPQUOTA -a | grep ^$f | awk '{print $4}'`
	HARDLIMIT=`$REPQUOTA -a | grep ^$f | awk '{print $5}'`
	# wenn kein Softlimit ermittelt werden konnte, dann auf 0 setzen; kann passieren, wenn der 
	# Benutzername lnger als 9 Zeichen ist. Dann wird der Benutzername nach dem 10 Zeichen 
	# abgeschnitten und verbindet sich mit dem nchsten Feld
	if test "" = "$SOFTLIMIT" ; then
		SOFTLIMIT=0
	fi
	# Softlimit wurde gesetzt?
	if test ! "0" = "$SOFTLIMIT" ; then
		# echo "SOFTLIMIT: $SOFTLIMIT"
		# Softlimit ist kleiner (-lt) als USED
		if test "$SOFTLIMIT" -lt "$USED" ; then
			# Vorbereiten des Mailtextes: (nicht sehr elegant)
			cat $MESSAGE | sed s/{LOGIN}/$erg/g > /tmp/mailquotaMessage1
			cat /tmp/mailquotaMessage1 | sed s/{SOFTLIMIT}/$SOFTLIMIT/g > /tmp/mailquotaMessage2
			cat /tmp/mailquotaMessage2 | sed s/{HARDLIMIT}/$HARDLIMIT/g > /tmp/mailquotaMessage3
			cat /tmp/mailquotaMessage3 | sed s/{AKT}/$USED/g > /tmp/mailquotaMessage4
			# Warnung und Mail (ggf. auch an Admin)
			echo "WARNUNG: $erg hat Softlimit berschritten (benutzt: $USED)!"
			mailx -s "WARNUNG: Quota berschritten!" $erg < /tmp/mailquotaMessage4
		fi
	fi
done
