#!/bin/sh
# restart in tclsh \
exec tclsh "$0" "$@"

source cddb.tcl

#set cddb_debug 1

puts "Welcome to cddb.tcl!"
puts "querying..."

set _disc_data "af0a540d 13 150 14715 36107 50120 64152 75500 93337 106972 121985 130082 149545 168550 181557 2644"

set sock [_connect $cddb_server $cddb_port]
_cddb_hello $sock

_write_line $sock "cddb query $_disc_data"
set rsp [_read_line $sock]
set status [lindex $rsp 0]
if { "$status" != "200" } {
  if { "$status" != "211" } {
    puts "No match."
    exit
  } else {
    scan [cddb_inexact [_read_line $sock]] "%s %s" category disc_id
  }
} else {
  set category [lindex $rsp 1]
  set disc_id  [lindex $rsp 2]
}

array set mycd [cddb_read $category $disc_id]

if [info exists mycd(artist)] {
  puts ""
  puts "Artist : $mycd(artist)"
  puts "Album  : $mycd(album)"
  puts ""
}

for { set i 1 } { $i <= $mycd(tracks) } { incr i } {
  puts [format "%2d : %s" $i $mycd($i)]
}
puts ""

