#!/bin/sh
# restart in tclsh \
exec tclsh "$0" "$@"

puts "Welcome to cddb.tcl!"

source cddb.tcl

puts -nonewline "Source directory \[.] " ; flush stdout
set rip_dir [gets stdin]
if { "$rip_dir" == "" } { 
  set rip_dir "."
}
puts -nonewline "Filename prefix \[audio] " ; flush stdout
set prefix [gets stdin]
if { "$prefix" == "" } {
  set prefix audio
}
puts -nonewline "Filename suffix \[mp3] "
set suffix [gets stdin]
if { "$suffix" == "" } {
  set suffix mp3
}

puts "querying..."
scan [cddb_query] "%s %s" category disc_id
array set mycd [cddb_read $category $disc_id]

if [info exists mycd(artist)] {
  puts ""
  puts "Artist : $mycd(artist)"
  puts "Album  : $mycd(album)"
  puts ""
}


for { set i 1 } { $i <= $mycd(tracks) } { incr i } {
  puts "$i : $mycd($i)"
  if { [string length $i] == 1 } {
    set track_num "0$i"
  } else {
    set track_num $i
  }
  set track_name [join "$prefix $track_num.$suffix" "_"]
  set filename [file join $rip_dir $track_name]
  if [file exists $filename] {
    set default "$mycd(artist) - $mycd(album) - $track_num - $mycd($i).mp3"
    puts "Rename $track_name -> $default"
    file rename $filename [file join $rip_dir "$default"]
  }
}
