#!/bin/sh
# restart in tclsh \
exec tclsh "$0" "$@"

puts "Welcome to cddb.tcl!"
source cddb.tcl

#set cddb_debug 1

puts "querying..."
scan [cddb_query] "%s %s" category disc_id

if ![info exists category] {
  # no match was found.
  return
}

array set mycd [cddb_read $category $disc_id]

if [info exists mycd(artist)] {
  puts ""
  puts "Artist : $mycd(artist)"
  puts "Album  : $mycd(album)"
  puts ""
}

for { set i 1 } { $i <= $mycd(tracks) } { incr i } {
  puts [format "%2d : %s" $i $mycd($i)]
}
puts ""
