/*
 * Decompiled with CFR 0.152.
 */
package com.hemju.biborder;

import com.hemju.biborder.OrderStrategy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OrderBibRef
implements OrderStrategy {
    private static final char[] FOOTNOTE = new char[]{'@', 'f', 'o', 'o', 't', 'n', 'o', 't', 'e', ':', '\n'};
    private static final int WRITE_BUFFER_SIZE = 16384;
    private static final int READ_BUFFER_SIZE = 16384;
    private static final int BIB_REF_BUFFER_SIZE = 2048;
    private static final char[] READ_BUFFER = new char[16384];
    private static final char[] WRITE_BUFFER = new char[16384];
    private static final char[] BIB_REF_BUFFER = new char[2048];
    private static final int DIGITAL_MIN_VALUE = 48;

    public void order(InputStream in, OutputStream out) {
        try {
            int charsRead;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(in)));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new BufferedOutputStream(out)));
            LinkedList<BibRefEntry> list = new LinkedList<BibRefEntry>();
            int charsWritten = 0;
            int bibRefWritten = -1;
            int footnoteIndex = 0;
            while ((charsRead = reader.read(READ_BUFFER)) >= 0) {
                for (int j = 0; j < charsRead; ++j) {
                    char actChar = READ_BUFFER[j];
                    if (footnoteIndex < FOOTNOTE.length) {
                        footnoteIndex = actChar == FOOTNOTE[footnoteIndex] ? ++footnoteIndex : 0;
                        OrderBibRef.WRITE_BUFFER[charsWritten++] = actChar;
                        if (charsWritten < 16384) continue;
                        writer.write(WRITE_BUFFER);
                        charsWritten = 0;
                        continue;
                    }
                    if (charsWritten != 0) {
                        writer.write(WRITE_BUFFER);
                        charsWritten = 0;
                    }
                    if (actChar == '[') {
                        if (bibRefWritten == -1) {
                            bibRefWritten = 0;
                        } else {
                            char[] text = Arrays.copyOfRange(BIB_REF_BUFFER, 0, bibRefWritten);
                            list.add(new BibRefEntry(text));
                            bibRefWritten = 0;
                        }
                    }
                    if (bibRefWritten == -1) continue;
                    OrderBibRef.BIB_REF_BUFFER[bibRefWritten++] = actChar;
                }
            }
            Collections.sort(list);
            for (BibRefEntry bibRefEntry : list) {
                writer.write(bibRefEntry.text);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(OrderBibRef.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BibRefEntry
    implements Comparable<BibRefEntry> {
        private final int tag;
        private final char[] text;

        public BibRefEntry(char[] text) {
            int tagLength = 1;
            while (text[tagLength] != ']') {
                ++tagLength;
            }
            int tagLength2 = --tagLength - 1;
            int t = 0;
            int pos = 0;
            for (int i = 0; i < tagLength; ++i) {
                if (i != tagLength2) {
                    pos = (int)Math.pow(10.0, tagLength2 - i);
                    t += (text[i + 1] - 48) * pos;
                    continue;
                }
                t += text[i + 1] - 48;
            }
            this.tag = t;
            this.text = text;
        }

        @Override
        public int compareTo(BibRefEntry o) {
            return this.tag - o.tag;
        }

        public String toString() {
            return "tag: " + this.tag + " text: " + new String(this.text);
        }
    }
}

