var JSONTableModel = function(jsonData, fields, header) {

}

var HopTableModel = function(parent, fields, header) {
  this.parent = parent;
  this.fields = fields;
  this.header = header;
  this.columns = fields.length;
  this.rows = parent.size();

  this.get = function(column, row) {
    var object = this.parent.get(row);
    var value = object[fields[column]];
    if (typeof(value) == 'function') {
      value = value.apply(object);
    }
    return value;
  };

  this.getColumnName = function(column) {
    return header[column];
  }
};

var TableRenderer = function(model) {
  this.model = model;

  this.render = function() {
    var str = "";
    str += '<table border="1"><thead>';
    for (var column = 0; column < model.columns; column++) {
      str += "<th>" + model.getColumnName(column) + "</th>";
    }
    str += "</thead><tbody>\n";
    for (var row = 0; row < model.rows; row++) {
      str += '<tr>\n';
      for (var column = 0; column < model.columns; column++) {
        str += "<td>" + model.get(column, row) + "</td>\n";
      }
      str += "</tr>\n";
    }
    str += "</tbody></table>\n";
    return str;
  }
}