Feed.prototype.main_action = function() {
  var syndFeed = this.getFeed(this.url);

  if (this.title != syndFeed.title) {
    this.title = syndFeed.title;
  }
  if (this.description != syndFeed.description) {
    this.description = syndFeed.description;
  }

  var entries = this.getEntries(syndFeed);
  var list = "";
  for (var i = 0; i < entries.length; i++) {
    list += entries[i].renderSkinAsString("entry");
  }

  this.renderSkin("feed", { list: list });
}

Feed.prototype.getEntries = function(syndFeed) {
  var result = [];
  var entries = syndFeed.getEntries();
  for (var i = 0; i < entries.size(); i++) {
    result[i] =  new Entry(entries.get(i));
  }
  return result;
}

Feed.prototype.link = function() {
  return '<a href="/' + this._id + '/">' + this.title + "</a>";
}

Feed.prototype.getFeed = function(url) {
  var Url = Packages.java.net.URL;
  var SyndFeed = Packages.com.sun.syndication.feed.synd.SyndFeed;
  var SyndFeedInput = Packages.com.sun.syndication.io.SyndFeedInput;
  var XmlReader = Packages.com.sun.syndication.io.XmlReader;

  var input = new SyndFeedInput();
  var syndFeed = input.build(new XmlReader(new Url(url)));
  return syndFeed;
}

Feed.prototype.href_macro = function() {
  return this.href();
}