/*
 * Copyright (c) 2010, Johan Thelin
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with 
 * or without modification, are permitted provided that 
 * the following conditions are met:
 *
 *   - Redistributions of source code must retain the above
 *     copyright notice, this list of conditions and the 
 *     following disclaimer.
 *   - Redistributions in binary form must reproduce the
 *     above copyright notice, this list of conditions and
 *     the following disclaimer in the documentation and/or
 *     other materials provided with the distribution.
 *   - The name of Johan Thelin may not be used to endorse
 *     or promote products derived from this software 
 *     without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL 
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

#include "viewwidget.h"

#include <QGraphicsBlurEffect>
#include <QGraphicsObject>
#include <QGraphicsProxyWidget>
#include <QGraphicsScene>
#include <QPropertyAnimation>
#include <QPushButton>

ViewWidget::ViewWidget(QWidget *parent)
    : QGraphicsView(parent)
{
    setRenderHints(QPainter::Antialiasing | QPainter::SmoothPixmapTransform);

    QGraphicsScene *scene = new QGraphicsScene(-100, -100, 200, 200, this);
    setScene(scene);

    QPushButton *blurButton = new QPushButton("Blur");
    QGraphicsProxyWidget *blurItem = scene->addWidget(blurButton);
    blurItem->setPos(-blurButton->width()/2, -10-blurButton->height());
    QGraphicsBlurEffect *blurEffect = new QGraphicsBlurEffect(this);
    blurEffect->setBlurRadius(0);
    blurItem->setGraphicsEffect(blurEffect);

    QPushButton *rotateButton = new QPushButton("Rotation");
    QGraphicsProxyWidget *rotateItem = scene->addWidget(rotateButton);
    rotateItem->setTransformOriginPoint(rotateButton->width()/2, rotateButton->height()/2);
    rotateItem->setPos(-rotateButton->width()/2, 10);

    QPropertyAnimation *blurAnimation = new QPropertyAnimation(blurEffect, "blurRadius", this);
    blurAnimation->setStartValue(0.0);
    blurAnimation->setKeyValueAt(0.5, 10.0);
    blurAnimation->setEndValue(0.0);
    blurAnimation->setDuration(1500);
    connect(blurButton, SIGNAL(clicked()), blurAnimation, SLOT(start()));

    QPropertyAnimation *rotateAnimation = new QPropertyAnimation(rotateItem, "rotation", this);
    rotateAnimation->setStartValue(0.0);
    rotateAnimation->setEndValue(360.0);
    rotateAnimation->setDuration(2000);
    rotateAnimation->setEasingCurve(QEasingCurve::OutBounce);
    connect(rotateButton, SIGNAL(clicked()), rotateAnimation, SLOT(start()));
}

ViewWidget::~ViewWidget()
{

}
