

runtest() {
  mkdir -p $UTHOME/System
  rm -rf $UTBENCH/Benchmark/Logs/*.log
  rm -rf $UTBENCH/Benchmark/Results/*.res
  rm -rf $UTHOME/Benchmark/Logs/*.log
  rm -rf $UTHOME/Benchmark/Results/*.log

  for CONFIGURATION in $CONFIGURATIONS; do
    for RESOLUTION in $RESOLUTIONS; do
      for FSAAMODE in $FSAAMODES; do
        for ANISOMODE in $ANISOMODES; do
          cp $UTBENCH/System/$CONFIGURATION-$RESOLUTION-UT2004.ini $UTHOME/System/UT2004.ini
  	  export __GL_FSAA_MODE=$FSAAMODE
	  export __GL_LOG_MAX_ANISO=$ANISOMODE
          ut2004 -exitafterdemo -benchmark -nosound -seconds=77 -exec=$UTBENCH/Benchmark/benchmark.exec
	  grep "frames in.*seconds" $UTHOME/System/UT2004.log | sed -e "s/.*(//" | sed -e "s/ fps)//" > $UTBENCH/Benchmark/Results/$CONFIGURATION-$RESOLUTION-$FSAAMODE-$ANISOMODE-UT2004.res
	  mv $UTHOME/System/UT2004.log $UTBENCH/Benchmark/Logs/$CONFIGURATION-$RESOLUTION-$FSAAMODE-$ANISOMODE-UT2004.log
        done
      done
    done
  done
  return 0
}


runsuite() {
  case $1 in
    '')
      exit 1
      ;;
    --everything)
      # Everything
      CONFIGURATIONS="Default Minimum Maximum"
      RESOLUTIONS="1600x1200 1280x1024 1024x0768 0800x0600"
      FSAAMODES="0 1 2 4 5 6 7 8"
      ANISOMODES="0 1 2 3 4"
      ;;
    --resolution)
      # Resolution influence
      CONFIGURATIONS="Default"
      RESOLUTIONS="1600x1200 1280x1024 1024x0768 0800x0600"
      FSAAMODES="0"
      ANISOMODES="0"
      ;;
    --details)
      # Details influence
      CONFIGURATIONS="Minimum Default Maximum"
      RESOLUTIONS="1600x1200"
      FSAAMODES="0"
      ANISOMODES="0"
      ;;
    --fsaa)
      # fsaa influence
      CONFIGURATIONS="Default"
      RESOLUTIONS="1600x1200"
      FSAAMODES="0 1 2 4 5 6 7 8"
      ANISOMODES="0"
      ;;
    --aniso)
      # fsaa influence
      CONFIGURATIONS="Default"
      RESOLUTIONS="1600x1200"
      FSAAMODES="0"
      ANISOMODES="0 1 2 3 4"
      ;;
    --fsaa5aniso2)
      CONFIGURATIONS="Default"
      RESOLUTIONS="1600x1200"
      FSAAMODES="5"
      ANISOMODES="2"     
      ;;
    --fsaa8aniso4)
      CONFIGURATIONS="Default"
      RESOLUTIONS="1600x1200"
      FSAAMODES="8"
      ANISOMODES="4"
      ;;
    --widescreen)
      # widescreen
      CONFIGURATIONS="Default"
      RESOLUTIONS="3840x1024"
      FSAAMODES="0 5 6 8"
      ANISOMODES="0 2 4"
      ;;
  esac
  runtest
  return 0
}


CARD=$1

UTHOME=$HOME/.ut2004
UTBENCH=$HOME/utbench

TESTS="resolution details fsaa aniso fsaa5aniso2 fsaa8aniso4"
#TESTS="widescreen"

rm -rf $CARD
mkdir -p $CARD

for TEST in $TESTS; do
  runsuite --$TEST
  mkdir -p $CARD/$TEST
  cp -r Benchmark/Results $CARD/$TEST/
  cp -r Benchmark/Logs    $CARD/$TEST/
done

