

runtest() {
  rm -rf $ETBENCH/Benchmark/Logs/*.log
  rm -rf $ETBENCH/Benchmark/Results/*.res

  for CONFIGURATION in $CONFIGURATIONS; do
    for RESOLETION in $RESOLETIONS; do
      for FSAAMODE in $FSAAMODES; do
        for ANISOMODE in $ANISOMODES; do
          cd $HOME
          rm -rf .etwolf
          tar -xzf $ETBENCH/Configs/$CONFIGURATION-$RESOLETION-etwolf.tgz
          cd -
  	  export __GL_FSAA_MODE=$FSAAMODE
	  export __GL_LOG_MAX_ANISO=$ANISOMODE
          et +benchmark +timedemo 1 +demo radar 2>&1 >&0 | ./detect.sh > etwolf.log
          sleep 1
          grep " frames, .* seconds: .* fps" etwolf.log | sed -e "s/.* frames, .* seconds: //" | sed -e "s/ fps//" \
            > $ETBENCH/Benchmark/Results/$CONFIGURATION-$RESOLETION-$FSAAMODE-$ANISOMODE-etwolf.res
 	  mv etwolf.log $ETBENCH/Benchmark/Logs/$CONFIGURATION-$RESOLETION-$FSAAMODE-$ANISOMODE-etwolf.log
        done
      done
    done
  done
  return 0
}


runsuite() {
  case $1 in
    '')
      exit 1
      ;;
    --everything)
      # Everything
      CONFIGURATIONS="Default Minimum Maximum"
      RESOLETIONS="1600x1200 1280x1024 1024x0768 0800x0600"
      FSAAMODES="0 1 2 4 5 6 7 8"
      ANISOMODES="0 1 2 3 4"
      ;;
    --resolution)
      # Resolution influence
      CONFIGURATIONS="Default"
      RESOLETIONS="1600x1200 1280x1024 1024x0768 0800x0600"
      FSAAMODES="0"
      ANISOMODES="0"
      ;;
    --fsaa)
      # fsaa influence
      CONFIGURATIONS="Default"
      RESOLETIONS="1600x1200"
      FSAAMODES="0 1 2 4 5 6 7 8"
      ANISOMODES="0"
      ;;
    --aniso)
      # aniso influence
      CONFIGURATIONS="Default"
      RESOLETIONS="1600x1200"
      FSAAMODES="0"
      ANISOMODES="0 1 2 3 4"
      ;;
    --fsaa5aniso2)
      #
      CONFIGURATIONS="Default"
      RESOLETIONS="1600x1200"
      FSAAMODES="5"
      ANISOMODES="2"
      ;;
    --fsaa8aniso4)
      #
      CONFIGURATIONS="Default"
      RESOLETIONS="1600x1200"
      FSAAMODES="8"
      ANISOMODES="4"
      ;;
  esac
  runtest
  return 0
}


CARD=$1

ETBENCH=$HOME/etbench

TESTS="resolution fsaa aniso fsaa5aniso2 fsaa8aniso4"

rm -rf $CARD
mkdir -p $CARD

for TEST in $TESTS; do
  runsuite --$TEST
  mkdir -p $CARD/$TEST
  cp -r Benchmark/Results $CARD/$TEST/
  cp -r Benchmark/Logs    $CARD/$TEST/
done

