#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define SIZE 30000

#include <omp.h>

void Calculate()
{
    int generalProgress=0,i,j,percentDone, found=0,procid=0;
    static double X[SIZE];

#ifdef _OPENMP
    printf("\nprocesses used:%d\n",omp_get_num_procs());
    procid=omp_get_thread_num();
#endif

#pragma omp parallel for private(i,j,percentDone) shared(generalProgress,X) reduction(+:found) schedule(static,10)
    for( i = 0; i <= SIZE; i ++ )
    {
        X[i] = sqrt(exp(cos(i))*exp(sin(i)));
        for(j=1;j<i;j++)
          X[i] *= sqrt(exp(cos(j))*exp(sin(i)));

        if( X[i] > 0.5)
        {
            found ++;
        }

#pragma omp critical
        generalProgress++;

if(procid == 0)
{
        percentDone = (int)((float)generalProgress/(float)SIZE *100.0 + 0.5);

        if( percentDone % 10 == 0 )
            printf("\n\b\b\b\b%3d%%", percentDone);
	/* note: you could reduce # printf() - not done to show impact 
           of implicit locking */
}

    }
    printf("\nfound %d\n",found);
}

int main(int argc, char **argv)
{
    Calculate();
}
