#include <stdio.h>
#include <hal/libhal.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>

int main(int argc, char **argv)
{
  static LibHalContext *ctx;
  DBusError dbus_error;
  DBusConnection *dbus_conn;
  char **devices;
  int i_devices, i;
  char *udi;


  dbus_error_init(&dbus_error);
  dbus_conn = dbus_bus_get (DBUS_BUS_SYSTEM, &dbus_error);
  if (dbus_error_is_set(&dbus_error)) {
    g_warning("Could not connect to system bus %s\n", dbus_error.message);
    dbus_error_free (&dbus_error);
    return 1;
  }

  ctx = libhal_ctx_new();
  if (ctx == NULL) {
    g_warning("Could not create HAL context\n");
  }

  libhal_ctx_set_dbus_connection(ctx, dbus_conn);

  // Anfrage an HAL: alle Geräte auflisten
  if (!(devices = libhal_get_all_devices (ctx, &i_devices, &dbus_error))) {
     warn ("HAL not running: %s", dbus_error.message);
     dbus_error_free (&dbus_error);
     libhal_ctx_shutdown (ctx, NULL);
     libhal_ctx_free (ctx);
     return 1;
  }

  for (i = 0; i < i_devices; i++) {
    printf("%s\n", devices[i]);
  }
      
  dbus_error_free (&dbus_error);
  libhal_ctx_free(ctx);
}
