#include <stdio.h>
#include <hal/libhal.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>

static void device_added (LibHalContext *ctx, const char *udi)
{
  char **cap;
  char *parent_udi;
  size_t n;

  if (!(cap = libhal_device_get_property_strlist(ctx, udi, "info.capabilities", NULL))) {
     return;
  }

  // iterate over capabilities list
  for (n = 0; cap[n]; n++) {
     if (strcmp(cap[n], "alsa") == 0) {
        printf ("Alsa %s device added: ", libhal_device_get_property_string(ctx, udi, "alsa.type", NULL));
        printf ("%s ", libhal_device_get_property_string(ctx, udi, "alsa.device_file", NULL));
	
	parent_udi = libhal_device_get_property_string(ctx, udi, "info.parent", NULL);
	parent_udi = libhal_device_get_property_string(ctx, parent_udi, "info.parent", NULL);

        printf ("(%s)\n", libhal_device_get_property_string(ctx, parent_udi, "info.vendor", NULL));
     } else {
        //printf ("other device added: %s\n", udi);
     }
  }
}


int main(int argc, char **argv)
{
   static LibHalContext *ctx;
   DBusError dbus_error;
   DBusConnection *dbus_conn;
   GMainLoop *loop;
   char **devices;
   int nr;
   
   ctx = libhal_ctx_new();
   if (ctx == NULL) {
      g_warning("Could not create HAL context\n");
   }

   dbus_error_init(&dbus_error);
   dbus_conn = dbus_bus_get (DBUS_BUS_SYSTEM, &dbus_error);

   if (dbus_error_is_set(&dbus_error)) {
      g_warning("Could not connect to system bus %s\n", dbus_error.message);
   }
   dbus_connection_setup_with_g_main (dbus_conn, NULL);
   dbus_connection_set_exit_on_disconnect (dbus_conn, FALSE);
	
   libhal_ctx_set_dbus_connection(ctx, dbus_conn);
   libhal_ctx_set_device_added(ctx, device_added);

   if (!libhal_ctx_init (ctx, &dbus_error)) {
      warn ("libhal_ctx_init failed: %s", dbus_error.message);
      dbus_error_free (&dbus_error);
      libhal_ctx_free (ctx);
      return 1;
   }
				
   if (!(devices = libhal_get_all_devices (ctx, &nr, &dbus_error))) {
      warn ("hald not running: %s", dbus_error.message);
      dbus_error_free (&dbus_error);
												
      libhal_ctx_shutdown (ctx, NULL);
      libhal_ctx_free (ctx);
      return 1;
   }

   // main loop
   loop = g_main_new(FALSE);
   g_main_run(loop);

   libhal_ctx_free(ctx);
}
