#ifndef WATERMARK_DIALOG_H
#define WATERMARK_DIALOG_H
#include <libkipi/interface.h>
#include <kdialogbase.h>
#include <qurl.h>
class QSpinBox;
class PreviewArea;
class QTextEdit;

namespace KIPI
{
    class UploadWidget;
}

class WatermarkDialog : public KDialogBase {
    Q_OBJECT

public:
    WatermarkDialog( KIPI::Interface* interface, QWidget* parent, const char* name = 0 );

public slots:
    void reload();
    virtual void slotOk();
    void slotChangeFont();

protected slots:
    void repaintPixmap();

protected:
    void addSettingsPage();
    void addDestPage();
    KURL::List images();
    QPixmap paintImage( const QPixmap& image );
    QPixmap pixmapForURL( const KURL& url );
    void savePixmap( const KURL& url, const QPixmap& pixmap );


private:
    KIPI::Interface* m_interface;
    PreviewArea* m_previewArea;
    QTextEdit* m_text;
    QPushButton* m_font;
    KIPI::UploadWidget* m_uploadWidget;
    QPixmap m_pixmap;
};


#endif /* WATERMARK_DIALOG_H */

