#include "previewarea.h"
#include <qpainter.h>
#include <kurl.h>
#include <qimage.h>
#include <kdebug.h>
#include <qlabel.h>

PreviewArea::PreviewArea( QWidget* parent, const char* name )
    :QWidget( parent, name )
{
    setBackgroundMode( NoBackground );
}

void PreviewArea::paintEvent( QPaintEvent* )
{
    QPainter painter( this );
    painter.drawImage( QPoint(0,0), m_image );
}

QSize PreviewArea::scaledSize( const QSize& size )
{
    int w = size.width();
    int h = size.height();
    if ( w > h )
        return QSize( 400, (h * 400)/w );
    else
        return QSize( (w*400)/h, 400 );

}

void PreviewArea::setPixmap( const QPixmap& pix )
{
    QImage img = pix.convertToImage();
    m_image = img.smoothScale( scaledSize( img.size() ), QImage::ScaleMin );
    setFixedSize( scaledSize( img.size() ) );
    update();
}
