#include "plugin_watermark.h"
#include "watermark_dialog.h"
#include <kgenericfactory.h>
#include <libkipi/imageinfo.h>

typedef KGenericFactory<WatermarkPlugin> Factory;

K_EXPORT_COMPONENT_FACTORY( kipiplugin_watermark,
                            Factory("kipiplugin_watermark"))

WatermarkPlugin::WatermarkPlugin( QObject *parent, const char* name,
                              const QStringList& )
    :KIPI::Plugin::Plugin( Factory::instance(), parent, name )
{
    kdDebug( 51001 ) << "Loaded WatermarkPlugin" << endl;
}

void WatermarkPlugin::setup( QWidget* widget )
{
    KIPI::Plugin::setup( widget );

    KIPI::Interface* interface = static_cast<KIPI::Interface*>( parent() );
    m_dialog = new WatermarkDialog( interface, 0, "watermark plugin dialog" );
    m_dialog->resize( 800, 600 );

    m_imageInfo = new KAction( i18n( "Watermarks" ), "",
                               0, this, SLOT( action() ), actionCollection(),
                               "watermark" );
    addAction( m_imageInfo );

    connect( interface, SIGNAL( currentAlbumChanged( bool ) ),
             m_dialog, SLOT( reload() ) );
    connect( interface, SIGNAL( selectionChanged( bool ) ),
             m_dialog, SLOT( reload() ) );
}

KIPI::Category WatermarkPlugin::category( KAction* ) const
{
    return KIPI::IMAGESPLUGIN;
}

void WatermarkPlugin::action()
{
    m_dialog->reload();
    m_dialog->show();
}

