#*************************************************************************
#*
#*  $RCSfile: unospection.tcl,v $
#*
#*  $Revision: 1.4 $
#*
#*  last change: $Author: wiede $ $Date: 2005/10/19 16:01:50 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#* 	- BSD License
#*
#*	see file license.terms in this directory
#*
#*  Copyright 2005 Wolfgang Grosser
#*
#*  Author: Wolfgang Grosser
#*
#*  Contributor(s): 
#*
#************************************************************************/

set ::argv -urtp

set home [ file join [pwd] ..]
lappend auto_path .
lappend auto_path [ file join $home tclurtp]
lappend auto_path [ file join $home tcluno]
lappend auto_path [ file join $home itcluno]

set script_path [file join [pwd] [file dirname [info script]]]
package require log
package require tclurtp
package require tcluno_soffice

package require Tk
option add *Panedwindow*showHandle 0

proc structDocumentation {w n} {
	set text [[winfo parent $w] itemcget $n -text]
	set splittedText [split $text {.}]
	if {[llength $splittedText] < 3} {
		set text [string map [list {::} {:}] $text]
		set splittedText [split $text/module-ix {:}]
	}
	showDocumentation [join $splittedText {/}].html
}
proc getCommand {w} {
	set lastCommand [$w getLastCommand]
	regsub -all ___DESKTOP___ $lastCommand \$desktop lastCommand
	if {[string length [lindex $lastCommand 0]] > 0} {
		set ::structArray([lindex $lastCommand 0]) [lindex $lastCommand 0]
		lappend ::loggedCommands "set ::structArray([lindex $lastCommand 0]) \[[lindex $lastCommand 1]\]"
	} else {
		lappend ::loggedCommands "[lindex $lastCommand 1]"
	}
}
proc setComboValue {w v idx} {
	upvar $v values
	switch $::COMBOBOX {
		ComboBox {
			$w setvalue @$idx
		}
		ttk::combobox {
			$w set [lindex $values $idx]
		}
	}
}

lappend auto_path .
package require BWidget
#if {![catch {package require tile}]} {
#	package require tablelist_tile
# 	tile::setTheme step
# 	set LABEL ::ttk::label
# 	set BUTTON ::ttk::button
# 	set ENTRY ::ttk::entry
# 	set COMBOBOX ttk::combobox
# 	set CHECKBUTTON ttk::checkbutton
# 	set RADIOBUTTON ttk::radiobutton
# } else {
	package require tablelist
	tablelist::addBWidgetComboBox
	set LABEL label
	set BUTTON button
	set ENTRY entry
	set COMBOBOX ComboBox
	set CHECKBUTTON checkbutton
	set RADIOBUTTON radiobutton
#}
package require tcluno_type_info
package require tcluno_scalc
package require tcluno_swriter

set loggedCommands [list]
set objectRef 0
proc doSave {} {
	set filename [tk_getSaveFile]
	if {[string length $filename] == 0} {
		return
	}
	set fd [open $filename w]
	puts $fd "lappend auto_path ."
	puts $fd "package require tclurtp"
	puts $fd "package require tcluno_scalc"
	puts $fd ""
	puts $fd "set desktop \[tcluno_soffice::initDesktop\]"
	puts $fd ""

	foreach e [array names ::structArray] {
		regsub -all $e $::loggedCommands \$::structArray($e) ::loggedCommands
	}
	regsub -all {set ::structArray\(\$::structArray\(::tcluno::handle0x(........)\)\)} $::loggedCommands {set ::structArray(::tcluno::handle0x\1)} ::loggedCommands
	regsub -all {set ::structArray\(\$::structArray\(::tclUrtpBridge::handle(.*[^)])\)\)} $::loggedCommands {set ::structArray(::tclUrtpBridge::handle\1)} ::loggedCommands
	regsub -all {set ::structArray\(\$::structArray\(::tclUrtpBridge::struct(.*[^)])\)\)} $::loggedCommands {set ::structArray(::tclUrtpBridge::struct\1)} ::loggedCommands
	regsub -all {set ::structArray\(\$::structArray\(::tclUrtpBridge::sequence(.*[^)])\)\)} $::loggedCommands {set ::structArray(::tclUrtpBridge::sequence\1)} ::loggedCommands
	regsub -all {set ::structArray\(\$::structArray\(::tclUrtpBridge::special(.*[^)])\)\)} $::loggedCommands {set ::structArray(::tclUrtpBridge::special\1)} ::loggedCommands
	set start [string first {::tcluno::handle0x} $::loggedCommands]
	#	25 = [string length ::tcluno::handle0x] + 8 byte address
	set handleCount 0
	while {$start >= 0} {
		set handle [string range $::loggedCommands $start [expr {$start+25}]]
		set nickname [$::structWin getNodeByData cmd_handle $handle nickname]
		if {[string length $nickname] == 0} {
			set nickname handle$handleCount
		}
		regsub -all $handle $::loggedCommands $nickname ::loggedCommands
		incr handleCount
		set start [string first {::tcluno::handle0x} $::loggedCommands]
	}
	puts $fd [join $::loggedCommands "\n"]

	puts $fd ""
	puts $fd "#\tneed this for flushing"
	puts $fd "after 10"
	close $fd
}
proc _exit {w} {
	set answer [tk_messageBox -title "Save logging" -icon info -type yesnocancel \
		-message "Do You want to save the logged commands?"]
	if  {[string equal $answer {cancel}]} {
		return
	}
	if  {[string equal $answer {yes}]} {
		doSave
	}
	wm protocol $w WM_DELETE_WINDOW ""
	destroy $w
}
proc searchMethods {desktop {pattern ""}} {
	upvar script_path script_path

	set top .method_search
	if {[llength [info commands UnoMethodsTreeReport]] == 0} {
		source [file join $script_path uno_methods_tree.tcl]
		toplevel $top
		wm protocol $top WM_DELETE_WINDOW [list wm withdraw $top]
		wm title $top "Look for Methods"
		UnoMethodsTreeReport $top.ddtr $desktop
		pack $top.ddtr -expand 1 -fill both
	}
	wm deiconify $top
	raise $top
	if {[string length $pattern] > 0} {
		$top.ddtr findMethodPaths $pattern
	}
}
proc showStructures {toplevel} {
	if {![winfo exists $toplevel]} {
		toplevel $toplevel
		wm protocol $toplevel WM_DELETE_WINDOW [list wm withdraw $toplevel]
		set ::structWin $toplevel.ddtr
		.dispatch register $::widgets(tree) [list <<TCLUNO_COMMAND>> [list getCommand $::structWin]]
		::DoubleDragTreeReport $::structWin $::desktop
		$::structWin GetStruct com.sun.star.beans.PropertyValue
		pack $::structWin
		$::structWin.sw2.t2 bindText <Shift-ButtonRelease-1> [list structDocumentation %W]
	}
	wm deiconify $toplevel
	raise $toplevel
}
proc makeMenu {desktop {top ""}} {
	menu $top.menu
	set m $top.menu.file
	menu $m -tearoff false
	$top.menu add cascade -label "File" -menu $m -underline 0
	$m add separator
	set toplevel $top
	if {[string length $top] == 0} {
		set toplevel .
	}
	$m add command -label Save -command [list doSave]
	$m add command -label Exit -command [list _exit $toplevel]
	set m $top.menu.edit
	menu $m -tearoff false
	$top.menu add cascade -label "Edit" -menu $m -underline 0
	$m add command -label "Structures" -command [list showStructures $top.structs]
	$m add command -label "Search Methods" -command [list searchMethods $desktop]
	set m $top.menu.help
	menu $m -tearoff false
	$top.menu add cascade -label "Help" -menu $m -underline 0
	$m add command -label "Documentation" -command [list showDocumentation]
	$toplevel configure -menu $top.menu
}
proc makeGui {widgetA {top ""}} {
	upvar $widgetA w
	panedwindow $top.pw
	set f [panedwindow $top.tree_and_objects -orient vertical]
	$top.pw add $f

	ScrolledWindow $f.sw_tree
	$f add $f.sw_tree
	set row 1
	set w(tree) [Tree $f.tree]
	$f.tree bindText <Button-1> [list addMethods $widgetA 1 ""]
	$f.tree bindText <Double-Button-1> [list treeCallMethod $widgetA $f.tree]
#	$f.tree bindText <Button-3> [list showData $f.tree]
	$f.sw_tree setwidget $f.tree
#	grid $f.sw_tree -row $row -column 1 -sticky wens
#	grid rowconfigure $f $row -weight 3
	incr row

	ScrolledWindow $f.sw_objects
	$f add $f.sw_objects
	set w(objects) [listbox $f.objects -listvariable ::objectList]
	bind $w(objects) <<ListboxSelect>> [list showObject $widgetA]
	bind $w(objects) <ButtonRelease-3> [list renameObject $widgetA %W %y]
	$f.sw_objects setwidget $f.objects
#	grid $f.sw_objects -row $row -column 1 -sticky wens
#	grid rowconfigure $f $row -weight 1

#	grid $f -column 0 -row 1 -sticky nswe

	set f [frame $top.objects]
	$top.pw add $f

	set row 1

	set objectFrame [frame $f.object]
	$::LABEL $objectFrame.objectL -text Object:
	$::LABEL $objectFrame.objectVarL -text Variable:
	$::LABEL $objectFrame.objectTypeL -text ObjectType:
	set w(object) [$::LABEL $objectFrame.object -text ""]
	set w(objectVar) [$::LABEL $objectFrame.objectVar -text ""]
	set w(objectType) [$::LABEL $objectFrame.objectType -text ""]
	pack $objectFrame.objectL $w(object) \
		$objectFrame.objectVarL $w(objectVar) \
		$objectFrame.objectTypeL $w(objectType) -side left
	grid $objectFrame -row $row -column 1 -sticky wn
	incr row

	$::BUTTON $f.refresh -text Refresh
	grid $f.refresh -column 1 -row $row -sticky w
	incr row

	set pwf [panedwindow $f.properties_and_methods -orient vertical]
	ScrolledWindow $pwf.sw_properties
	$pwf add $pwf.sw_properties
	set w(properties) [tablelist::tablelist $pwf.properties \
				-labelcommand tablelist::sortByColumn \
				-columns [list \
					0 Name left \
					0 Handle right \
					0 Type left \
					0 Attribute right \
					0 Value left \
				] \
				-editendcommand [list setNewPropertyValue $widgetA]
			]
	$w(properties) columnconfigure 4 -editable 1 ; #-editwindow entry
	$pwf.sw_properties setwidget $pwf.properties
#	grid $f -column 1 -row $row -sticky nswe
#	grid $f.sw_properties -row $row -column 1 -sticky wens
#	grid rowconfigure $f $row -weight 1
#	grid columnconfigure $f 1 -weight 1
	$f.refresh configure -command [list refreshProperties $widgetA]

	incr row

	ScrolledWindow $pwf.sw_methods
	$pwf add $pwf.sw_methods
	set w(methods) [tablelist::tablelist $pwf.methods \
				-labelcommand tablelist::sortByColumn \
				-columns [list \
					0 Type left \
					0 Method left \
					0 Params left \
				]
			]
	$pwf.sw_methods setwidget $pwf.methods
	bind [$w(methods) bodytag] <Double-Button-1> [list tableCallMethod %y $widgetA]
#	grid $f.sw_methods -row $row -column 1 -sticky wens
	grid $pwf -column 1 -row $row -sticky nswe
	grid rowconfigure $f $row -weight 1
	grid columnconfigure $f 1 -weight 1


	grid $top.pw -column 1 -row 1 -sticky nswe
	if {[string length $top] == 0} {
		set top .
	}
	grid rowconfigure $top 1 -weight 1
	grid columnconfigure $top 1 -weight 1

	wm protocol $top WM_DELETE_WINDOW [list _exit $top]
	return [array get w]
}
proc setProperties {w obj propertySet} {
	$w delete 0 end
	if {[string length $propertySet] == 0} {
		return
	}
	set row 0
	foreach property [$propertySet getProperties] {
		array set prop [eval concat [lindex $property 1]]
		set prop(Value) [$obj getPropertyValue $prop(Name)]
		$w insert end [list $prop(Name) $prop(Handle) $prop(Type) $prop(Attributes) $prop(Value)]
		if {[string equal -nocase $prop(Type) {boolean}]} {
			$w cellconfigure $row,4 -editwindow $::CHECKBUTTON
		}
		if {[string first com.sun.star.beans.PropertyValue $prop(Type)] >= 0} {
			$w cellconfigure $row,4 -editwindow $::COMBOBOX
		}
		incr row
	}
}
proc refreshProperties {widgetA} {
	upvar $widgetA w
	set object [$w(object) cget -text]
	if {![catch {$object getPropertySetInfo} propertySet]} {
		setProperties $w(properties) $object $propertySet
	}
}
proc setMethods {w infosA} {
	upvar $infosA infos
	$w delete 0 end
	foreach e [lsort [array names infos]] {
		array set tmp $infos($e)
		set paramList [list]
		foreach {dir type name} $tmp(params) {
			lappend paramList $name
		}
		$w insert end [list $tmp(ret_type) $e $paramList]
	}
}
proc setObjectVariable {w v} {
	if {[lsearch -exact [$w get 0 end] $v] >= 0} {
		return
	}
	$w insert end $v
}
proc renameObject {widgetA w y} {
	upvar $widgetA widgets
	set objectIdx [$w nearest $y]
	catch {destroy $w.rename}
	toplevel $w.rename
	$::LABEL $w.rename.oldLabel -text "Old Name:" -anchor w
	$::ENTRY $w.rename.old
	$w.rename.old insert end [eval lindex $[$w cget -listvariable] $objectIdx]
	$::LABEL $w.rename.newLabel -text "New Name:"
	$::ENTRY $w.rename.new
	grid $w.rename.oldLabel -row 1 -column 1 -sticky w
	grid $w.rename.old -row 1 -column 2 -sticky we
	grid $w.rename.newLabel -row 2 -column 1 -sticky w
	grid $w.rename.new -row 2 -column 2 -sticky we
	bind $w.rename.new <Return> [list doRenameObject $widgetA [$w cget -listvariable] $objectIdx $w.rename.new]
}
proc findVarMethodNode {w var method} {
	set node [findVarNode $w $var]
	foreach n [$w nodes $node] {
		if {[string equal $method [$w itemcget $n -text]]} {
			return $n
		}
	}
	return -1
}
proc findObject {ret_type} {
	set result [list]
	puts stderr findObject:$ret_type:
	foreach e [array names ::objectArray] {
		puts stderr $::objectArray($e)
		unset -nocomplain tmp
		array set tmp $::objectArray($e)
		puts stderr :$tmp(ret_type)<-->$ret_type:
		if {[info exists tmp(ret_type)] && [string equal $ret_type $tmp(ret_type)]} {
			lappend result "@$e"
		}
	}
	puts stderr $result
	return $result
}
proc findVarNode {w var {root root}} {
	foreach n [$w nodes $root] {
		if {[string equal $var [$w itemcget $n -data]]} {
			return $n
		}
		set node [findVarNode $w $var $n]
		if {$node > 0} {
			return $node
		}
	}
	return -1
}
proc findNodeByVar {widgetA var {root root}} {
	upvar $widgetA w
	foreach n [$w(tree) nodes $root] {
		if {[string equal $var [$w(tree) itemcget $n -data]]} {
			addMethods $widgetA 1 $var $n
			$w(tree) see $n
			$w(tree) selection set $n
			return
		}
		set node [findNodeByVar $widgetA $var $n]
		if {$node >= 0} {
			addMethods $widgetA 1 $var $node
			$w(tree) see $node
			$w(tree) selection set $node
			return
		}
	}
	return
}
proc showObject {widgetA} {
	upvar $widgetA w
	set var [$w(objects) get [$w(objects) curselection]]
	findNodeByVar $widgetA $var
}
proc doRenameObject {widgetA listboxVar idx entry} {
	upvar $widgetA widgets
	set oldVar [eval lindex $$listboxVar $idx]
	set oldValue $::objectArray($oldVar)
	set newVar [$entry get]
	set node [findVarNode $widgets(tree) $oldVar]
	$widgets(tree) itemconfigure $node -data $newVar
	$widgets(tree) itemconfigure $node -text "Object $newVar"
	if {[string equal $node [$widgets(tree) selection get]]} {
		$widgets(objectVar) configure -text $newVar
	}
	set ::objectArray($newVar) $oldValue
	unset ::objectArray($oldVar)
	lappend ::loggedCommands "set $newVar \$$oldVar"
	set $listboxVar [eval lreplace $$listboxVar $idx $idx [list $newVar]]
}
proc renameObject {widgetA w y} {
	upvar $widgetA widgets
	set objectIdx [$w nearest $y]
	catch {destroy $w.rename}
	toplevel $w.rename
	$::LABEL $w.rename.oldLabel -text "Old Name:" -anchor w
	$::ENTRY $w.rename.old
	$w.rename.old insert end [eval lindex $[$w cget -listvariable] $objectIdx]
	$::LABEL $w.rename.newLabel -text "New Name:"
	$::ENTRY $w.rename.new
	grid $w.rename.oldLabel -row 1 -column 1 -sticky w
	grid $w.rename.old -row 1 -column 2 -sticky we
	grid $w.rename.newLabel -row 2 -column 1 -sticky w
	grid $w.rename.new -row 2 -column 2 -sticky we
	bind $w.rename.new <Return> [list doRenameObject $widgetA [$w cget -listvariable] $objectIdx $w.rename.new]
}
proc tableCallMethod {y w} {
	upvar $w widgets
	incr y [winfo height [$widgets(methods) labelpath 0]]
	set row [$widgets(methods) nearest $y]
	set var [$widgets(objectVar) cget -text]
	set method [$widgets(methods) cellcget $row,1 -text]
	set node [findVarMethodNode $widgets(tree) $var $method]
	$widgets(tree) selection set $node
	makeMethodCall widgets $var $method $node
}
proc treeCallMethod {w t n} {
	upvar $w widgets
	set node [$t selection get]
	set method [$t itemcget $node -text]
	set parent [$t parent $node]
	set var [$t itemcget $parent -data]
	makeMethodCall widgets $var $method $node
}
proc makeMethodCall {w var method node} {
	upvar $w widgets
	array set objectA $::objectArray($var)
	array set params [tcluno_soffice::getMemberMethodInfo $objectA(value) $method]
	if {[string equal [winfo toplevel $widgets(tree)] {.}]} {
		set top ._method_call
	} else {
		set top [winfo toplevel $widgets(tree)]._method_call
	}
	catch {destroy $top}
	toplevel $top
	wm transient $top [winfo toplevel $widgets(tree)]
	set headerFrame [frame $top.headerFrame]
	$::LABEL $headerFrame.object -text $var
	$::LABEL $headerFrame.method -text $method
	set ret_type ""
	if {[info exists params(ret_type)]} {
		set ret_type $params(ret_type)
	}
	$::LABEL $headerFrame.ret_type -text $ret_type
	grid $headerFrame -row 0 -column 1 -columnspan 3 -sticky we
	pack $headerFrame.object -side left -anchor w
	pack $headerFrame.method -side left -anchor e
	pack $headerFrame.ret_type -side left -anchor e
	set row 1
	foreach {inout type name} $params(params) {
		set formattedRow [format {%02d} $row]
		$::LABEL $top.t$formattedRow -text $type
		$::LABEL $top.l$formattedRow -text $name
		set entry 1
		puts stderr $type
		set values [list]
		if {[string first com.sun.star $type] == 0} {
			set values [::tcluno_type_info::getEnumClassInfos $type]
			if {[string equal $values [::tcluno_type_info::unknown_type_info]]} {
				set values [list]
				set entry 0
			}
		}
		if {[string first com.sun.star $type] >= 0} {
			eval lappend values [$::structWin getStructs $type]
			set entry 0
		}
		if {$entry} {
			$::ENTRY $top.e$formattedRow
		} else {
			eval lappend values [findObject $type]
			$::COMBOBOX $top.e$formattedRow -values $values
			setComboValue $top.e$formattedRow values 0
		}
		grid $top.t$formattedRow -sticky w -column 1 -row $formattedRow
		grid $top.l$formattedRow -sticky w -column 2 -row $formattedRow
		grid $top.e$formattedRow -sticky we -column 3 -row $formattedRow -columnspan 2
		incr row
	}
	grid columnconfigure $top 3 -weight 1
	set buttonFrame [frame $top.buttonFrame]
	grid $buttonFrame -sticky we -column 1 -row $row -columnspan 3
	$::BUTTON $buttonFrame.execute -text "Execute" -command [list executeMethod $top $w $var $method $params(ret_type) $node]
	$::BUTTON $buttonFrame.help -text "Help" -command [list searchMethods $::desktop $method]
	$::BUTTON $buttonFrame.cancel -text "Cancel" -command [list destroy $top]
	pack $buttonFrame.execute -side left -anchor w
	pack $buttonFrame.help -side left -anchor w
	pack $buttonFrame.cancel -side right -anchor e
	incr row
	$::ENTRY $top.result -state disabled -disabledforeground black
	grid $top.result -row $row -column 1 -columnspan 3 -sticky we
	incr row
	$::LABEL $top.objectVarL -text ObjectVar
	$::ENTRY $top.objectVar
	if {![string equal $ret_type {void}]} {
		grid $top.objectVarL -row $row -column 1 -sticky we
		incr ::objectRef
		$top.objectVar insert end obj$::objectRef
		grid $top.objectVar -row $row -column 2 -columnspan 2 -sticky we
	}
}
proc setNewPropertyValue {w t r c v} {
	upvar $w widgets
	set object [$widgets(object) cget -text]
	set property [$widgets(properties) cellcget $r,0 -text]
	$object setPropertyValue $property $v
	set logObj [$widgets(objectVar) cget -text]
	set logObj "__DOLLAR__SIGN__$logObj"
	set logCmd "$logObj setPropertyValue $property $v"
	regsub {__DOLLAR__SIGN__} $logCmd {$} logCmd
	lappend ::loggedCommands $logCmd
	return [$object getPropertyValue $property]
}
proc executeMethod {w widgetA objectVar method ret_type node} {
	upvar $widgetA widgets
	set paramList [list]
	set logParamList [list]
	foreach c [lsort [winfo children $w]] {
		if {[string first {e} [winfo name $c]] != 0} continue
		set param [$c get]
		if {[string equal [winfo class $c] {Combobox}]} {
			set param [lindex $param 1]
		}
		set logParam $param
		if {[string first {@} $param] == 0} {
			unset -nocomplain tmp
			set tmpParam [string range $param 1 end]
			array set tmp $::objectArray($tmpParam)
			set param $tmp(value)
			set logParam {$}
			append logParam $tmpParam
		}
		lappend paramList $param
		lappend logParamList $logParam
	}
	array set tmp $::objectArray($objectVar)
	set object $tmp(value)
	if {[string equal $method {queryInterface}]} {
		set my_type [list TypeClass $paramList INTERFACE]
		set paramList [$object tcluno::getTclunoType $my_type]
		set my_type [list $my_type]
		set logParamList ""
		append logParamList {[$}
		append logParamList "$objectVar tcluno::getTclUnoType $my_type"
		append logParamList {]}
	}
	set cmd [concat $object $method $paramList]
	set logCmd ""
	append logCmd {$}
	append logCmd "$objectVar $method $logParamList"
	$w.result configure -state normal
	$w.result delete 0 end
	puts stderr $cmd
	regsub -all {\\t} $cmd "\t" cmd
	puts stderr $cmd
	regsub -all {\\n} $cmd "\n" cmd
	puts stderr $cmd
	set result [eval $cmd]
	$w.result insert end $result
	$w.result configure -state disabled
	set var [$w.objectVar get]
	set ::objectArray($var) [list value $result ret_type $ret_type]
	if {[string length $var] > 0} {
		lappend ::loggedCommands "set $var \[$logCmd\]"
	} else {
		lappend ::loggedCommands $logCmd
	}
	if {[string length $var] > 0} {
		addMethods $widgetA 0 $var $node
	}
}
proc addMethods {widgetA showOnly var node} {
	upvar $widgetA widgets
	if {![string equal $node root]} {
		$widgets(tree) itemconfigure $node -open 1
	}
	if {!$showOnly} {
		set node [$widgets(tree) insert end $node [incr ::nodeNum] -text "Object $var" -data $var -open 1]
	}
	if {[string length $var] == 0} {
		set var [$widgets(tree) itemcget $node -data]
		if {[string length $var] == 0} {
			set var [$widgets(tree) itemcget [$widgets(tree) parent $node] -data]
		}
	} else {
		set var [$widgets(tree) itemcget $node -data]
	}
	$widgets(tree) selection set $node

	array set tmp $::objectArray($var)
	$widgets(object) configure -text $tmp(value)
	$widgets(objectVar) configure -text $var
	$widgets(objectType) configure -text $tmp(ret_type)
	if {![catch {array set infos [tcluno_soffice::listMethodInfos $tmp(value)]}]} {
		if {![catch {$tmp(value) getPropertySetInfo} propertySet]} {
			setProperties $widgets(properties) $tmp(value) $propertySet
		} else {
			setProperties $widgets(properties) $tmp(value) ""
		}
		if {!$showOnly} {
			foreach e [lsort [array names infos]] {
				$widgets(tree) insert end $node [incr ::nodeNum] -text $e
			}
		}
		setMethods $widgets(methods) infos
		setObjectVariable $widgets(objects) $var
	}
	unset tmp
	$widgets(tree) see $node
}
source [file join $script_path dispatch.tcl]
source [file join $script_path documentation.tcl]
source [file join $script_path structuresTree.tcl]
set desktop [tcluno_soffice::initDesktop]
set objectArray(desktop) [list ret_type com.sun.star.Context value $desktop]
makeMenu $desktop
makeGui ::widgets
showStructures .structs
wm withdraw .structs
set nodeNum -1
addMethods widgets 0 desktop root
