#*************************************************************************
#*
#*  $RCSfile: uno_methods_tree.tcl,v $
#*
#*  $Revision: 1.3 $
#*
#*  last change: $Author: wiede $ $Date: 2005/09/07 11:02:01 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#*	 - GNU Lesser General Public License Version 2.1
#*
#*  GNU Lesser General Public License Version 2.1
#*  =============================================
#*  Copyright 2005 Wolfgang Grosser, Arnulf Wiedemann
#*
#*  This library is free software; you can redistribute it and/or
#*  modify it under the terms of the GNU Lesser General Public
#*  License version 2.1, as published by the Free Software Foundation.
#*
#*  This library is distributed in the hope that it will be useful,
#*  but WITHOUT ANY WARRANTY; without even the implied warranty of
#*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#*  Lesser General Public License for more details.
#*
#*  You should have received a copy of the GNU Lesser General Public
#*  License along with this library; if not, write to the Free Software
#*  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#*  MA  02111-1307  USA
#*
#*
#*  Author: Wolfgang Grosser
#*
#*   All Rights Reserved.
#*
#*   Contributor(s): Arnulf Wiedemann
#*
#*
#************************************************************************/

lappend auto_path .
catch {set tkPriv(x) 0}
package require Itk
package require BWidget
package require Iwidgets
package require tcluno_interface_info
catch {namespace children}
catch {itcl::delete class UnoMethodsTreeReport}
catch {itcl::delete object .ddtr}

::itcl::class UnoMethodsTreeReport {
	inherit itk::Widget

	itk_option define -width width Width 200
	itk_option define -height height Height 400
	itk_option define -showpath showpath Boolean false
	itk_option define -showlines showlines Boolean true
	itk_option define -drawcross drawcross String never
	itk_option define -maxshowpathlength maxshowpathlength Length 2

	private variable _resultWidget ""
	private variable _interface_fields
	private variable _interfaces_top_node
	private variable _kind_of_search simple

	protected variable _use_helptext 0
	protected variable _images
	protected variable _canvasPath
	protected variable _grid
	protected variable _current_node {}
	protected variable _headerToken
	protected variable _tableTitles
	protected variable _data
	protected variable _resultData
	protected variable node_editable
	protected variable node_options

	protected variable _desktop
	protected variable t1
	protected variable t2
	protected variable curr_path ""
	protected variable w_X 0
	protected variable w_Y 0
	protected variable w_y 0
	protected variable parent_id -1
	protected variable curr_node -1

	constructor {desktop args} {} {}
	
	private method _InitTrees {}
	private method _insertRows {start args}
	private method _searchMethods {w}
	private method _showDocumentation {t n}

	protected method GetDataValue {infos name}
	protected method resultWidget {{w ""}}

	public method insertRows {start args}
	public method findMethodPaths {pattern}
}

# *************************** constructor ***********************************

::itcl::body UnoMethodsTreeReport::constructor {desktop args} {
	set _desktop $desktop
       	foreach my_image {folder file openfold copy bold} {
	       	set _images($my_image) [Bitmap::get $my_image]
       	}
	itk_initialize
	resultWidget $itk_interior
	DynamicHelp::configure -background #FFFFC0
	DynamicHelp::configure -font {helvetica 10}
	_InitTrees
	$t1 bindText <Double-Button-1> [itcl::code $this _showDocumentation %W]
	$t2 bindText <Double-Button-1> [itcl::code $this _showDocumentation %W]
}

# *************************** _InitTrees ***********************************

::itcl::body UnoMethodsTreeReport::_InitTrees {} {
	set infos1 [list]
	set info_lst [list root t1_0 "RESULTS" openfold [list [list name RESULTS]] 1]
	lappend infos1 $info_lst
	set info_lst [list t1_0 t1_0:1 "INTERFACES" openfold [list [list name INTERFACES] [list type INTERFACES]] 1]
	lappend infos1 $info_lst

	set infos2 [list]
	set info_lst [list root t2_0 "INFOS" openfold [list [list name INFOS]] 1]
	lappend infos2 $info_lst
	set info_lst [list t2_0 t2_0:1 "INTERFACES" openfold [list [list name INTERFACES] [list type INTERFACES]] 1]
	set _methods_top_node t2_0:1
	lappend infos2 $info_lst

	set interface_modules [::tcluno_interface_info::getInterfaceModules]
	set cnt 1
	foreach module $interface_modules {
		set mod_cnt $cnt
		set info_lst [list t2_0:1 t2_0:1:t2_$cnt "$module" openfold [list [list name $module] [list type MODULE]] 0]
		lappend infos2 $info_lst
		incr cnt
		set interface_interfaces [::tcluno_interface_info::getInterfaceInterfaces $module]
		regsub -all {::} $module {.} my_module
		foreach interface_name $interface_interfaces {
			set interface_fields [::tcluno_interface_info::getInterfaceInterfaceInfos $my_module.$interface_name]
#puts stderr "interface_fields:$my_module.$interface_name:$interface_fields:"
			foreach {xx idl_source_name} [lindex $interface_fields 0] break
			# next line is temporary !!
			regsub udkapi $idl_source_name offapi idl_source_name
			set module_flds [split $interface_name {.}]
			set doku_file_name docs/[join $module_flds /].html
			set info_lst [list t2_0:1:t2_$mod_cnt t2_0:1:t2_$mod_cnt:t2_$cnt "$interface_name" file [list [list name $interface_name] [list type INTERFACE] [list idl_source_name $idl_source_name] [list doku_file_name $doku_file_name] [list interface_fields $interface_fields]] 0]
			lappend infos2 $info_lst
			set method_cnt 0
			foreach entry $interface_fields {
				foreach {txt method_name} $entry break
				switch -glob $txt {
				"method#*" {
					set info_lst [list t2_0:1:t2_$mod_cnt:t2_$cnt t2_0:1:t2_$mod_cnt:t2_$cnt:$method_cnt "$method_name" file [list [list name $method_name] [list type METHOD]] 0]
					lappend infos2 $info_lst
					incr method_cnt
				  }
				}
			}
			incr cnt
		}
	}
	set infos [list $infos1 $infos2]
	insertRows 0 $infos
}

# **************************** resultWidget ***************************

::itcl::body UnoMethodsTreeReport::resultWidget {{w ""}} {
	frame $w.searchFrame
	iwidgets::Entryfield $w.searchFrame.searchEntry -labeltext "Search:"
	$::RADIOBUTTON $w.searchFrame.simple -text "Simple Search" -variable [itcl::scope _kind_of_search] -value simple
	$::RADIOBUTTON $w.searchFrame.regexp -text "Regexp Search" -variable [itcl::scope _kind_of_search] -value regexp
    
	pack $w.searchFrame.searchEntry $w.searchFrame.simple $w.searchFrame.regexp -side left -anchor w
	grid $w.searchFrame -row 1 -column 1 -sticky nswe -columnspan 2
	bind [$w.searchFrame.searchEntry component entry] <Return> [itcl::code $this _searchMethods %W]
	set bwidgetVersion [package version BWidget]
       	if {[package vcompare $bwidgetVersion 1.3.1] <= 0} {
		set _grid "._grid"
       	} else {
		set _grid ""
       	}
       	if {[package vcompare $bwidgetVersion 1.3.0] < 0} {
	       	set _canvasPath :cmd
       	} else {
	      	set _canvasPath .c
       	}
	set sw1 [ScrolledWindow $w.sw1]
	set sw2 [ScrolledWindow $w.sw2]
	grid $sw1 -column 1 -row 2 -sticky wens
	grid $sw2 -column 2 -row 2 -sticky wens
	grid rowconfigure $w 2 -weight 1
	set t1 [Tree $sw1.t1 -width 50 -height 40 -bg white]
	set t2 [Tree $sw2.t2 -width 50 -height 40 -bg white]
	$sw1 setwidget $t1
	$sw2 setwidget $t2
	set _use_helptext 0
	if {![catch {$t1 insert end root n1 -helptext xx}]} {
		set _use_helptext 1
		$t1 delete [$t1 nodes root]
	}
#puts stderr "_use_helptext:$_use_helptext:"
	set _resultWidget $t1
	return $t1
}

# **************************** _insertRows *****************************

::itcl::body UnoMethodsTreeReport::_insertRows {start args} {
	set _resultData $args
	catch {unset node_editable}
	catch {unset node_options}
	foreach entry $_resultData {
		foreach {parent node node_name image data open_it editable item_options} $entry break
		set node_editable($node) $editable
		set node_options($node) $item_options
#puts stderr "INSERT_ROWS!$parent!$node!$node_name!$open_it"
		set had_error 0
		set cmd "$_resultWidget insert end $parent $node -data [list $data] -text [list $node_name] -open $open_it"
		if {[string length $image] > 0} {
			set my_image $_images($image)
			append cmd " -image $my_image"
		}
		if {$_use_helptext} {
			set my_infos [list]
			foreach entry $data {
				set type ""
				set value ""
				foreach {type value} $entry break
				lappend my_infos "$type $value"
			}
			set my_data [join $my_infos \n]
			append cmd " -helptype balloon -helptext [list $my_data]"
		}
		if {[catch {eval $cmd} msg]} {
			set had_error 1
			puts stderr "MM:$msg:$cmd:"
			if {[catch {puts stderr "RR:[$_resultWidget nodes root]:"} msg]} {
				puts stderr "RR2:msg:$msg:"
			}
		}
		if {! $had_error} {
			if {[string length $item_options] > 0} {
				eval $_resultWidget itemconfigure $node $item_options
			}
		}
	}
}

# *************************** insertRows ************************************

::itcl::body UnoMethodsTreeReport::insertRows {start infos} {
	foreach {infos1 infos2} $infos break
	set _resultWidget $t1
	eval _insertRows $start $infos1
	set _resultWidget $t2
	eval _insertRows $start $infos2
}

# *************************** GetDataValue **********************************

::itcl::body UnoMethodsTreeReport::GetDataValue {infos name} {
	foreach entry $infos {
		foreach {type value} $entry break
		if {[string compare $type $name] == 0}  {
		  	return $value
		}
	}
	return {}
}

# *************************** _searchMethods *******************************

::itcl::body UnoMethodsTreeReport::_searchMethods {w} {
	set searchString [$w get]
	if {[string equal $_kind_of_search {regexp}]} {
		set searchString "*$searchString*"
	}
	findMethodPaths $searchString
}

# *************************** _showDocumentation *******************************

::itcl::body UnoMethodsTreeReport::_showDocumentation {tree node} {
	#       tree contains the canvas
	set tree [winfo parent $tree]
	set nodeName [$tree itemcget $node -text]
	puts stderr $nodeName
	if {[llength [$tree nodes $node]] == 0} {
		set parentText [split [$tree itemcget [$tree parent $node] -text] {.}]
		if {[string first {:} $parentText] < 0} {
			set grandPaText [$tree itemcget [$tree parent [$tree parent $node]] -text]
			regsub -all {::} $grandPaText {/} grandPaText
			set parentText $grandPaText/$parentText
		}
#	       showDocumentation [join [concat $parentText $nodeName] {/}].html
		showDocumentation [join [list [join $parentText {/}].html $nodeName] {#}]
	} else {
		set suffix ""
		if {[string first {:} $nodeName] >= 0} {
			regsub -all {::} $nodeName {.} nodeName
			set suffix "/module-ix"
		}
		if {[string first {.} $nodeName] >= 0} {
			set parentText [split $nodeName {.}]
		}
		if {![info exists parentText]} {
			set parentText [$tree itemcget [$tree parent $node] -text]
			regsub -all {::} $parentText {/} parentText
			lappend parentText $nodeName
		}
		showDocumentation [join $parentText {/}]$suffix.html
	}
}

# *************************** findMethodPaths *******************************

::itcl::body UnoMethodsTreeReport::findMethodPaths {pattern} {
	set result [list]
	foreach module_node [$t2 nodes t2_0:1] {
		foreach interface_node [$t2 nodes $module_node] {
			foreach method_node [$t2 nodes $interface_node] {
				set method_name [GetDataValue [$t2 itemcget $method_node -data] name]
				set my_pattern [string tolower $pattern]
				set my_method_name [string tolower $method_name]
				if {[string match $my_pattern $my_method_name]} {
					lappend result [list $module_node $interface_node $method_node $method_name]
				}
			}
		}
	}
	$t1 delete [$t1 nodes t1_0:1]
	foreach entry $result {
		foreach {module_node interface_node method_node method_name} $entry break
		regsub -all t2 $module_node t1 my_module_node
		if {[lsearch [$t1 nodes t1_0:1] $my_module_node] < 0} {
			set module_data [$t2 itemcget $module_node -data]
			set module_name [GetDataValue $module_data name]
			set cmd "$t1 insert end t1_0:1 $my_module_node -text $module_name -data [list $module_data] -image $_images(openfold) -open 1"
			if {$_use_helptext} {
				set my_infos [list]
				foreach entry $module_data {
					set type ""
					set value ""
					foreach {type value} $entry break
					lappend my_infos "$type $value"
				}
				set my_data [join $my_infos \n]
				append cmd " -helptype balloon -helptext [list $my_data]"
			}
			eval $cmd
		}
		regsub -all t2 $interface_node t1 my_interface_node
		if {[lsearch [$t1 nodes $my_module_node] $my_interface_node] < 0} {
			set interface_data [$t2 itemcget $interface_node -data]
			set interface_name [GetDataValue $interface_data name]
			set cmd "$t1 insert end $my_module_node $my_interface_node -text $interface_name -data [list $interface_data] -image $_images(openfold) -open 1"
			if {$_use_helptext} {
				set my_infos [list]
				foreach entry $interface_data {
					set type ""
					set value ""
					foreach {type value} $entry break
					lappend my_infos "$type $value"
				}
				set my_data [join $my_infos \n]
				append cmd " -helptype balloon -helptext [list $my_data]"
			}
			eval $cmd
		}
		regsub -all t2 $method_node t1 my_method_node
		set method_data [$t2 itemcget $method_node -data]
		if {[lsearch [$t1 nodes $my_interface_node] $my_method_node] < 0} {
			set method_name [GetDataValue $method_data name]
			set cmd "$t1 insert end $my_interface_node $my_method_node -text $method_name -data [list $method_data] -image $_images(file) -open 1"
			if {$_use_helptext} {
				set my_infos [list]
				foreach entry $method_data {
					set type ""
					set value ""
					foreach {type value} $entry break
					lappend my_infos "$type $value"
				}
				set my_data [join $my_infos \n]
				append cmd " -helptype balloon -helptext [list $my_data]"
			}
			eval $cmd
		}
	}
}


# for testing set test to 1!!
set test 0

if {$test} {
	load ./libtcluno.so
	package require tcluno_soffice
	proc ::ResultCallBack {args} {
		puts stderr "===ResultCallBack: called with args:$args:"
	}

	if {[catch {set desktop [tcluno_soffice::initDesktop]} msg]} {
		puts stderr "error in tcluno_soffice::initDesktop:MSG:$msg:"
		exit 1
	}

	set my_win .ddtr
	UnoMethodsTreeReport $my_win $desktop
	$my_win findMethodPaths "*Property*"
	pack $my_win -expand 1 -fill both
}
