#*************************************************************************
#*
#*  $RCSfile: structuresTree.tcl,v $
#*
#*  $Revision: 1.4 $
#*
#*  last change: $Author: wiede $ $Date: 2005/09/07 11:02:01 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#*	 - GNU Lesser General Public License Version 2.1
#*
#*  GNU Lesser General Public License Version 2.1
#*  =============================================
#*  Copyright 2005 Arnulf Wiedemann, Wolfgang Grosser
#*
#*  This library is free software; you can redistribute it and/or
#*  modify it under the terms of the GNU Lesser General Public
#*  License version 2.1, as published by the Free Software Foundation.
#*
#*  This library is distributed in the hope that it will be useful,
#*  but WITHOUT ANY WARRANTY; without even the implied warranty of
#*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#*  Lesser General Public License for more details.
#*
#*  You should have received a copy of the GNU Lesser General Public
#*  License along with this library; if not, write to the Free Software
#*  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#*  MA  02111-1307  USA
#*
#*
#*  Author: Arnulf Wiedemann
#*
#*   All Rights Reserved.
#*
#*   Contributor(s): Wolfgang Grosser
#*
#*
#************************************************************************/

set test 0

catch {set tkPriv(x) 0}
package require Itk
package require BWidget
package require Iwidgets
package require tcluno_type_info
catch {namespace children}
catch {itcl::delete class ::DoubleDragTreeReport}
catch {itcl::delete object .ddtr}

::itcl::class ::DoubleDragTreeReport {
	inherit itk::Widget

	itk_option define -helpscript helpScript HelpScript {}
	itk_option define -balloonhelp balloonHelp BalloonHelp off
	itk_option define -width width Width 200
	itk_option define -height height Height 400
	itk_option define -showpath showpath Boolean false
	itk_option define -showlines showlines Boolean true
	itk_option define -drawcross drawcross String never
	itk_option define -maxshowpathlength maxshowpathlength Length 2

	private variable _resultWidget ""
	private variable _handleMenu .handle_menu
	private variable _handleStruct .handle_struct
	private variable _in_drag 0
	private variable _handle_drop 0
	private variable _drag_help_win [list]
	private variable _last_drag_help_x -1
	private variable _last_drag_help_y -1
	private variable _got_values 0
	private variable _values
	private variable _struct_fields
	private variable _structures_top_node
	private variable _result_call_back [list]

	private variable _help ".help"
	private variable _help_current ""
	private variable _help_id -1
	private variable _help_type
	private variable _help_saved ""
	private variable _help_initted 0
	private variable _last_help_text_idx {}
	private variable _last_command

	protected variable _show_debug_helptext 0
	protected variable _use_helptext 0
	protected variable _images
	protected variable _canvasPath
	protected variable _grid
	protected variable _current_node {}
	protected variable _headerToken
	protected variable _tableTitles
	protected variable _data
	protected variable _resultData
	protected variable node_editable
	protected variable node_options

	protected variable _desktop
	protected variable t1
	protected variable t2
	protected variable curr_path ""
	protected variable w_X 0
	protected variable w_Y 0
	protected variable w_y 0
	protected variable parent_id -1
	protected variable curr_node -1

	constructor {desktop args} {} {}
	
	private method _InitTrees {}
	private method _CallResultCallBack {w node}
	private method _OpenTree {struct_name}
	private method _UseStructInfo {}
	private method _GetStructInfo {to_path to_node}
	private method _GetPath {w node}
	private method _DragInit {path node w}
	private method _DragEnd {drag_source drop_target operation type data result}
	private method _HandleDropNode {from_path to_path lst data operation type}
	private method _Drop {tree_path drag_source lst operation type data}
	private method _MotionBalloon {type path X Y y node}
	private method _ShowHelp {path X Y y}
	private method _DestroyHelp {}
	private method _insertRows {start args}
	private method _getHelpText {type y}
	private method _showDocumentation {t n}

	protected method GetDataValue {infos name}
	protected method resultWidget {{w ""}}
	protected method _HelpBindings {}
	protected method _editNode {tree node}

	public method insertRows {start args}
	public method getHelpText {type y}
	public method handleNode {w node}
	public method ResetDrag {} { set _in_drag 0; set _handle_drag 0}
	public method RegisterResultCallBack {fcn}
	public method GetStruct {struct_name}
	public method getStructs {type {rootNode t1_0}}
	public method getLastCommand {}
	public method getNodeByData {data value returnData {root t1_0}}
}

# *************************** constructor ***********************************

::itcl::body ::DoubleDragTreeReport::constructor {desktop args} {
	set _desktop $desktop
       	foreach my_image {folder file openfold copy bold} {
	       	set _images($my_image) [Bitmap::get $my_image]
       	}
	itk_initialize
	resultWidget $itk_interior
	$t1 bindText <ButtonRelease-1> "$this handleNode $t1"
	$t1 bindText <ButtonPress-3> [itcl::code $this _editNode $t1]
	$t1 bindText <Double-Button-1> [::itcl::code $this _CallResultCallBack $t1]
	_HelpBindings
	_InitTrees
	$t1 bindText <Double-Button-1> [itcl::code $this _showDocumentation %W]
	$t2 bindText <Double-Button-1> [itcl::code $this _showDocumentation %W]
}

# *************************** _InitTrees ***********************************

::itcl::body ::DoubleDragTreeReport::_InitTrees {} {
	set infos1 [list]
	set info_lst [list root t1_0 "RESULTS" openfold [list [list name RESULTS]] 1]
	lappend infos1 $info_lst

	set infos2 [list]
	set info_lst [list root t2_0 "INFOS" openfold [list [list name INFOS]] 1]
	lappend infos2 $info_lst
	set info_lst [list t2_0 t2_0:1 "SEQUENCES" openfold [list [list name SEQUENCES] [list type SEQUENCES]] 1]
	lappend infos2 $info_lst
	set info_lst [list t2_0:1 t2_0:1:1 "ANY" file [list [list name ANY] [list type SEQUENCE]] 0]
	lappend infos2 $info_lst
	set info_lst [list t2_0 t2_0:2 "STRUCTURES" openfold [list [list name STRUCTURES] [list type STRUCTURES]] 1]
	set _structures_top_node t2_0:2
	lappend infos2 $info_lst

	set struct_modules [::tcluno_type_info::getStructModules]
	set cnt 1
	foreach module $struct_modules {
		set mod_cnt $cnt
		set info_lst [list t2_0:2 t2_0:2:t2_$cnt "$module" openfold [list [list name $module] [list type MODULE]] 0]
		lappend infos2 $info_lst
		incr cnt
		set struct_classes [::tcluno_type_info::getStructClasses $module]
		foreach class_name $struct_classes {
			set struct_fields [::tcluno_type_info::getStructClassInfos $class_name]
#puts stderr "struct_fields:$struct_fields:"
			set info_lst [list t2_0:2:t2_$mod_cnt t2_0:2:t2_$mod_cnt:t2_$cnt "$class_name" file [list [list name $class_name] [list type STRUCT] [list struct_fields $struct_fields]] 0]
			lappend infos2 $info_lst
			incr cnt
		}
	}
	set infos [list $infos1 $infos2]
	insertRows 0 $infos
}

# *************************** _HelpBindings ****************************

::itcl::body ::DoubleDragTreeReport::_HelpBindings {} {
	if {$_help_initted} {
		return
	}
	set _help_initted 1
	set _help_type($_resultWidget$_canvasPath) result
	foreach evt "Enter Motion Leave Button" {
		$_resultWidget bindText <$evt> +[::itcl::code $this _MotionBalloon $evt %W %X %Y %y]
	}
}

# **************************** _editNode **************************

::itcl::body ::DoubleDragTreeReport::_editNode {t n} {
	set res [$t edit $n [$t itemcget $n -text]]
	if {[string length $res] > 0} {
		set data [$t itemcget $n -data]
		set idx [lsearch -regexp $data {^nickname}]
		if {$idx >= 0} {
			set data [lreplace $data $idx $idx]
		}
		lappend data [list nickname $res]
		$t itemconfigure $n -text $res -data $data -helptext [join $data "\n"]
	}
}

# *************************** _MotionBalloon **************************

::itcl::body ::DoubleDragTreeReport::_MotionBalloon {type path X Y y node} {
	switch $itk_option(-balloonhelp) {
	no - off - 0 {
	  	return
	  }
	}
	if {$_help_current != $path && $type == "Enter"} {
		set _help_current $path
		set type "Motion"
		destroy $_help
	}
	set _current_node $node
	if {$_help_current == $path} {
		if {$_help_id != ""} {
			after cancel $_help_id
			set _help_id ""
		}
		if {$type == "Motion"} {
				set _help_id [after 600 [::itcl::code $this _ShowHelp $path $X $Y $y]]
		} else {
			switch $type {
			Button -
			Leave {
				$this getHelpText $_help_type($path) -1
			  }
			}
			destroy $_help
			set _help_current ""
		}
	}							
}

# *************************** _ShowHelp *******************************

::itcl::body ::DoubleDragTreeReport::_ShowHelp {path X Y y} {
	if {! [winfo exists $_help]} {
		toplevel $_help -relief flat \
			-bg black \
			-borderwidth 1 \
			-screen [winfo screen $path]
 
		wm overrideredirect $_help 1
		wm transient $_help
		label $_help.label -text "" \
			-relief flat -bd 0 -highlightthickness 0 \
			-foreground black \
			-background "#FFFFC0" \
			-font "helvetica 8" \
			-justify left
		pack $_help.label -side left
	}
	catch {
	set help_text [getHelpText $_help_type($path) $y]
	set doit 0
	if {[string length $help_text] > 0} {
		if {[string compare $_help_saved $help_text] != 0} {
			$_help.label configure -text $help_text
			update
		}
		set doit 1
	}
	set  scrwidth  [winfo vrootwidth  [winfo toplevel $itk_interior]]
	set  scrheight [winfo vrootheight [winfo toplevel $itk_interior]]
	set  width     [winfo reqwidth  $_help]
	set  height    [winfo reqheight $_help]			   
	incr Y 12
	incr X 8

	if {$X+$width > $scrwidth} {
		set X [expr {$scrwidth - $width}]
	}
	if {$Y+$height > $scrheight} {
		set y [expr {$Y - 12 - $height}]
	}
	if {$doit} {
		wm geometry  $_help "+$X+$Y"
	}
	set _help_saved $help_text
	}

	update idletasks
	update						
}

# *************************** _DestroyHelp ****************************

::itcl::body ::DoubleDragTreeReport::_DestroyHelp {} {
}

# *************************** _getHelpText *****************************

::itcl::body ::DoubleDragTreeReport::_getHelpText {type y} {
	if {$y == -1} {
		set _last_help_text_idx -1
		return {}
	}
	set idx $_current_node
	if {$_last_help_text_idx == $idx} {
		return {}
	}
	if {$idx == -1} {
		return {}
	}
	set _last_help_text_idx $idx
	set help_str [$_resultWidget itemcget $idx -data]
	set help_script $itk_option(-helpscript)
	if {[string length $help_script] == 0} {
		set str $help_str
	} else {
		regsub -all {[%][s]} $help_script $help_str help_script
		regsub -all {[%][d]} $help_script $idx help_script
		set id_val [lindex $itk_option(-listidvalues) $idx]
		regsub -all {[%][i]} $help_script $idx help_script
		set str [eval $help_script]
	}
	return $str
}

# *************************** _showDocumentation *******************************

::itcl::body ::DoubleDragTreeReport::_showDocumentation {tree node} {
	#	tree contains the canvas
	set tree [winfo parent $tree]
	set data [$tree itemcget $node -data]
	if {[string length $data] > 0} {
#		puts stderr $data
		set nodeName [GetDataValue $data name]
#		puts stderr $nodeName
	} else {
		set nodeName [$tree itemcget $node -text]
	}
	set suffix ""
	if {[string first {:} $nodeName] >= 0} {
		regsub -all {::} $nodeName {.} nodeName
		set suffix "/module-ix"
	}
	if {[string first {.} $nodeName] >= 0} {
		set parentText [split $nodeName {.}]
	}
	if {![info exists parentText]} {
		return
	}
	showDocumentation [join $parentText {/}]$suffix.html
}
# **************************** resultWidget ***************************

::itcl::body ::DoubleDragTreeReport::resultWidget {{w ""}} {
	set bwidgetVersion [package version BWidget]
       	if {[package vcompare $bwidgetVersion 1.3.1] <= 0} {
		set _grid "._grid"
       	} else {
		set _grid ""
       	}
       	if {[package vcompare $bwidgetVersion 1.3.0] < 0} {
	       	set _canvasPath :cmd
       	} else {
	      	set _canvasPath .c
       	}
	set sw1 [ScrolledWindow $w.sw1]
	set sw2 [ScrolledWindow $w.sw2]
	pack $sw1 $sw2 -side left -expand 1 -fill both
	set t1 [Tree $sw1.t1 -width 50 -height 40]
	set t2 [Tree $sw2.t2 -width 50 -height 40]
	$sw1 setwidget $t1
	$sw2 setwidget $t2
	set _use_helptext 0
	if {![catch {$t1 insert end root n1 -helptext xx}]} {
		set _use_helptext 1
		$t1 delete [$t1 nodes root]
	}
	$t1 configure -dragenabled true
	$t1 configure -dropenabled true
	$t1 configure -dragevent 3
	$t1 configure -dragtype DELETE
	$t1 configure -droptypes [list DELETE [list move control] TREE_NODE [list copy control]]
	$t1 configure -draginitcmd [::itcl::code $this _DragInit]
	$t1 configure -dragendcmd [::itcl::code $this _DragEnd]
	$t1 configure -dropcmd [::itcl::code $this _Drop]

	$t2 configure -dragenabled true
	$t2 configure -dropenabled true
	$t2 configure -dragevent 3
	$t2 configure -droptypes [list TREE_NODE [list copy control]]
	$t2 configure -draginitcmd [::itcl::code $this _DragInit]
	$t2 configure -dragendcmd [::itcl::code $this _DragEnd]
	$t2 configure -dropcmd [::itcl::code $this _Drop]

	set itk_option(-balloonhelp) off
	set _resultWidget $t1
	return $t1
}

# *************************** _CallResultCallBack ************************

::itcl::body ::DoubleDragTreeReport::_CallResultCallBack {w node} {
	set curr_node $node
	$t1 selection clear
	$t1 selection set $node
	if {[string length $_result_call_back] > 0} {
		set data [$t1 itemcget $node -data]
		set handle [GetDataValue $data cmd_handle]
		eval $_result_call_back $handle
	}
}

# *************************** _OpenTree *********************************

::itcl::body ::DoubleDragTreeReport::_OpenTree {struct_name} {
	foreach node [$t2 nodes $_structures_top_node] {
		$t2 closetree $node 1
	}
	set found 0
	foreach node [$t2 nodes $_structures_top_node] {
		set sub_nodes [$t2 nodes $node]
		foreach sub_node $sub_nodes {
			set data [$t2 itemcget $sub_node -data]
			set name [GetDataValue $data name]
			if {[string compare $name $struct_name] == 0} {
				$t2 opentree $node
				$t2 selection set $sub_node
				set found 1
				break
			}
		}
		if {$found} {
			break
		}
	}
}

# **************************** _insertRows *****************************

::itcl::body ::DoubleDragTreeReport::_insertRows {start args} {
	set _resultData $args
	catch {unset node_editable}
	catch {unset node_options}
	foreach entry $_resultData {
		foreach {parent node node_name image data open_it editable item_options} $entry break
		set node_editable($node) $editable
		set node_options($node) $item_options
		set had_error 0
		set cmd "$_resultWidget insert end $parent $node -data [list $data] -text $node_name -open $open_it"
		if {[string length $image] > 0} {
			set my_image $_images($image)
			append cmd " -image $my_image"
		}
		if {$_use_helptext} {
			set my_infos [list]
			foreach entry $data {
				set type ""
				set value ""
				foreach {type value} $entry break
				lappend my_infos "$type $value"
			}
			set my_data [join $my_infos "\n"]
			append cmd " -helptype balloon -helptext [list $my_data]"
		}
		if {[catch {eval $cmd} msg]} {
			set had_error 1
			if {[catch {puts stderr "RR:[$_resultWidget nodes root]:"} msg]} {
				puts stderr "RR2:msg:$msg:"
			}
			return
		}
		if {! $had_error} {
			if {[string length $item_options] > 0} {
				eval $_resultWidget itemconfigure $node $item_options
			}
		}
	}
}

# *************************** insertRows ************************************

::itcl::body ::DoubleDragTreeReport::insertRows {start infos} {
	foreach {infos1 infos2} $infos break
	set _resultWidget $t1
	eval _insertRows $start $infos1
	set _resultWidget $t2
	eval _insertRows $start $infos2
}

# *************************** getHelpText ***********************************

::itcl::body ::DoubleDragTreeReport::getHelpText {type y} {
	set infos [_getHelpText $type $y]
	if {[string length $infos] == 0} {
		return {}
	}
	set my_infos [list]
	foreach entry $infos {
		foreach {type str value} $entry break
		lappend my_infos "$str $value"
	}
	return [join $my_infos \n]
}

# *************************** _UseStructInfo *****************************

::itcl::body ::DoubleDragTreeReport::_UseStructInfo {} {
	foreach entry $_struct_fields {
		foreach {field def_val} $entry break
		set _values($field) [$_handleStruct.w$field get]
		pack forget $_handleStruct.w$field
		destroy $_handleStruct.w$field
	}
	pack forget $_handleStruct.action
	wm withdraw $_handleStruct
	grab release $_handleStruct
	set _got_values 1
}

# *************************** _GetStructInfo *****************************

::itcl::body ::DoubleDragTreeReport::_GetStructInfo {to_path to_node} {
	if {! [winfo exists $_handleStruct]} {
		toplevel $_handleStruct -relief flat \
			-background lightgrey \
			-borderwidth 1 \
			-screen [winfo screen [winfo toplevel $itk_interior]]

		wm overrideredirect $_handleStruct 1
		button $_handleStruct.action -text use -command [::itcl::code $this _UseStructInfo]
	}
	set pack_infos [list]
	set first_time 1
	foreach entry $_struct_fields {
		foreach {field def_val} $entry break
		::iwidgets::Entryfield $_handleStruct.w$field -labeltext $field
		lappend pack_infos $_handleStruct.w$field
		if {$first_time} {
			set first_time 0
			set focus_win $_handleStruct.w$field
		}
	}
	eval iwidgets::Labeledwidget::alignlabels $pack_infos
	eval pack $pack_infos $_handleStruct.action -side top -anchor w -fill both -expand 1
	wm deiconify $_handleStruct
	set bbox [$to_path.c bbox [$to_path.c find withtag n:$to_node]]
	set x [lindex $bbox 0]
	incr x [winfo rootx [winfo toplevel $itk_interior]]
	set y [lindex $bbox 3]
	incr y [winfo rooty [winfo toplevel $itk_interior]]
	wm geometry $_handleStruct +$x+$y
	raise $_handleStruct
	grab set $_handleStruct
	focus [$focus_win component entry]
	update idletasks
	update
	set _got_values 0
	vwait [::itcl::scope _got_values]
}

# *************************** GetDataValue **********************************

::itcl::body ::DoubleDragTreeReport::GetDataValue {infos name} {
	foreach entry $infos {
		foreach {type value} $entry break
		if {[string compare $type $name] == 0}  {
		  	return $value
		}
	}
	return {}
}

# *************************** handleNode ***********************************

::itcl::body ::DoubleDragTreeReport::handleNode {w node} {
	set curr_node $node
	$w selection clear
	$w selection set $node
}

# *************************** _GetPath ****************************************

::itcl::body ::DoubleDragTreeReport::_GetPath {w node} {
	if {[string compare $node root] == 0} {
		return ""
	}
	set path [_GetPath $w [$w parent $node]]
	return [eval list $path $node]
}

# *************************** _DragInit ************************************

::itcl::body ::DoubleDragTreeReport::_DragInit {path node w} {
	if {[string compare $path $t1] == 0} {
		set my_drag_type DELETE
	} else {
		set my_drag_type TREE_NODE
	}
	if {! $_in_drag} {
		set _in_drag 1
	} else {
		return [list $my_drag_type [list] [list]]
	}
	set my_data [$path itemcget $node -data]
	set my_path [_GetPath $path $node]
	label $w.l -text "$node:$my_data"
	pack $w.l
	return [list $my_drag_type [list copy move] [list $my_path $my_data]]
}

# *************************** _DragEnd *************************************

::itcl::body ::DoubleDragTreeReport::_DragEnd {drag_source drop_target operation type data result} {
}

# *************************** _HandleDropNode **********************************

::itcl::body ::DoubleDragTreeReport::_HandleDropNode {from_path to_path lst data operation type} {
	if {! $_handle_drop} {
		set _handle_drop 1
	} else {
		return 0
	}
	switch $type {
	DELETE {
		foreach {old_path old_data} $data break
		set node_val [lindex $old_path end]
		set parent_node_val 1:$parent_id
	  	$t1 delete $node_val
		set my_image $_images(file)
		set name [GetDataValue $old_data name]
		$t2 insert end $parent_node_val $node_val -text "$name" -data $old_data -image $my_image
		set _handle_drop 0
		return 1
	  }
	}
	switch $operation {
	copy {
	  }
	move {
	  }
	default {
		puts stderr "FUNNY operation:$operation in _HandleDropNode"
		set do_delete 0
	  }
	}
	foreach {type to_node pos2} $lst break
	foreach {old_path old_data} $data break
	set name [GetDataValue $old_data name]
	set my_image $_images(file)
	switch $type {
	position {
#		$to_path insert $pos2 $to_node $new_node -text "$name" -data $old_data -image $my_image
	   }
	node {
		foreach {old_path old_data} $data break
		set node_type [GetDataValue $old_data type]
		switch $node_type {
		SEQUENCE {
			set handle [$_desktop tcluno::createUnoSequence Any]
			lappend old_data [list cmd_handle $handle]
			set cmd "$to_path insert end $to_node #auto -text [list "Sequence $name ($handle)"] -data [list $old_data] -image $my_image -open 1"
			if {$_use_helptext} {
				set my_data [join $old_data "\n"]
				append cmd " -helptype balloon -helptext [list $my_data]"
			}
			set _last_command "[list $handle [list ___DESKTOP___ tcluno::createUnoSequence Any]]"
			.dispatch generate <<TCLUNO_COMMAND>>
			if {[catch {eval $cmd} msg]} {
				puts stderr catched:$msg:
				puts stderr catched:$cmd:
				set _handle_drop 0
			}
		  }
		STRUCT {
			set parent_data [$to_path itemcget $to_node -data]
			set parent_type [GetDataValue $parent_data type]
			set parent_handle ""
			switch $parent_type {
			SEQUENCE {
			  	set parent_handle [GetDataValue $parent_data cmd_handle]
			  }
			}
			set _struct_fields [GetDataValue $old_data struct_fields]
			_GetStructInfo $to_path $to_node
			set init_lst [list]
			foreach entry $_struct_fields {
				foreach {field def_val} $entry break
				lappend old_data [list $field $_values($field)]
				lappend init_lst $_values($field)
			}
			if {[catch {set my_property_struct [$_desktop tcluno::createUnoStructHelper $name $init_lst]} msg]} {
				puts stderr "tcluno::createUnoStructHelper:$msg:"
				set _handle_drop 0
				return 1
			}
			set _last_command "[list $my_property_struct [list ___DESKTOP___ tcluno::createUnoStructHelper $name $init_lst]]"
			.dispatch generate <<TCLUNO_COMMAND>>
			if {[string length $parent_handle] > 0} {
				set is_ok [$_desktop tcluno::appendUnoSequence $parent_handle $my_property_struct]
				set _last_command "[list [list] [list ___DESKTOP___ tcluno::appendUnoSequence $parent_handle $my_property_struct]]"
				.dispatch generate <<TCLUNO_COMMAND>>
			}
			lappend old_data [list cmd_handle $my_property_struct]
			set cmd "$to_path insert end $to_node #auto -text [list "struct $name ($my_property_struct)"] -data [list $old_data] -image $my_image"
			if {$_use_helptext} {
				set my_data [join $old_data "\n"]
				append cmd " -helptype balloon -helptext [list $my_data]"
			}
			eval $cmd
	  	  }
		default {
		  }
		}
	  }
	default {
	  	puts stderr "$type:default:"
	  }
	}
	set _handle_drop 0
	return 1
}

# *************************** _Drop ****************************************

::itcl::body ::DoubleDragTreeReport::_Drop {tree_path drag_source lst operation type data} {
	set ret 0
	switch $operation {
	copy {
	  }
	move {
		set _in_drag 0
	  	return $ret
	  }
	default {
		set operation copy
	  }
	}
	if {[catch {
	set ret [_HandleDropNode $drag_source $tree_path $lst $data $operation $type]
	} msg]} {
		puts stderr "error:$msg:"
	}
	set _in_drag 0
	return $ret
}

# *************************** RegisterResultCallBack ************************

::itcl::body ::DoubleDragTreeReport::RegisterResultCallBack {fcn} {
	set _result_call_back $fcn
}

# *************************** GetStruct *************************************

::itcl::body ::DoubleDragTreeReport::GetStruct {struct_name} {
	_OpenTree $struct_name
}

# *************************** getStructs *************************************

::itcl::body ::DoubleDragTreeReport::getStructs {type {rootNode t1_0}} {
	set searchForSequence 0
	if {[string first {[]} $type] == 0} {
		set searchForSequence 1
		set type [string range $type 2 end]
	}
	set result [list]
	if {$searchForSequence} {
		foreach n [$t1 nodes $rootNode] {
			set data [$t1 itemcget $n -data]
			if {[string equal [GetDataValue $data type] {SEQUENCE}]} {
				if {[string equal [GetDataValue $data name] ANY]} {
					set nickname [GetDataValue $data nickname]
					if {[string length $nickname] > 0} {
						lappend result "@$nickname"
					} else {
						lappend result [GetDataValue $data cmd_handle]
					}
				}
			}
		}
	}
	foreach n [$t1 nodes $rootNode] {
		set data [$t1 itemcget $n -data]
		if {[string equal [GetDataValue $data type] {SEQUENCE}]} {
			if {$searchForSequence} {
				set tmpResult [getStructs $type $n]
				if {[llength $tmpResult] > 0} {
					set nickname [GetDataValue $data nickname]
					if {[string length $nickname] > 0} {
						lappend result "@$nickname"
					} else {
						lappend result [GetDataValue $data cmd_handle]
					}
				}
			}
			continue
		}
		if {[string equal $type [GetDataValue $data name]]} {
			lappend result [GetDataValue $data cmd_handle]
		}
	}
	return $result
}
# *************************** getLastCommand *************************************

::itcl::body ::DoubleDragTreeReport::getLastCommand {} {
	return $_last_command
}

# *************************** getNodeByData *************************************

::itcl::body ::DoubleDragTreeReport::getNodeByData {dataname value returnDataname {root t1_0}} {
	foreach n [$t1 nodes $root] {
		set nodeData [$t1 itemcget $n -data]
		set nodeValue [GetDataValue $nodeData $dataname]
		if {[string equal $nodeValue $value]} {
			return [GetDataValue $nodeData $returnDataname]
		}
	}
}


# for testing set if clause to 1!!
if {$test} {
	load ./libtcluno.so
	package require tcluno_soffice
	proc ::ResultCallBack {args} {
		puts stderr "===ResultCallBack: called with args:$args:"
	}

	if {[catch {set desktop [tcluno_soffice::initDesktop]} msg]} {
		puts stderr "error in tcluno_soffice::initDesktop:MSG:$msg:"
		exit 1
	}

	set my_win .ddtr
	::DoubleDragTreeReport $my_win $desktop
	$my_win RegisterResultCallBack ::ResultCallBack
	$my_win GetStruct com.sun.star.beans.PropertyValue
	pack $my_win
}
