#*************************************************************************
#*
#*  $RCSfile: documentation.tcl,v $
#*
#*  $Revision: 1.3 $
#*
#*  last change: $Author: wiede $ $Date: 2005/09/07 11:02:01 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#*	 - GNU Lesser General Public License Version 2.1
#*
#*  GNU Lesser General Public License Version 2.1
#*  =============================================
#*  Copyright 2005 Wolfgang Grosser
#*
#*  This library is free software; you can redistribute it and/or
#*  modify it under the terms of the GNU Lesser General Public
#*  License version 2.1, as published by the Free Software Foundation.
#*
#*  This library is distributed in the hope that it will be useful,
#*  but WITHOUT ANY WARRANTY; without even the implied warranty of
#*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#*  Lesser General Public License for more details.
#*
#*  You should have received a copy of the GNU Lesser General Public
#*  License along with this library; if not, write to the Free Software
#*  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#*  MA  02111-1307  USA
#*
#*
#*  Author: Wolfgang Grosser
#*
#*   All Rights Reserved.
#*
#*   Contributor(s): 
#*
#*
#************************************************************************/

set notFoundPage {
<html><title>Not Found</title><body>File %s not found</body></html>
}
proc goBack {} {
	set lastUrl [lindex $::visitedUrls end-1]
	set ::visitedUrls [lreplace $::visitedUrls end-1 end]
	showDocumentation $lastUrl
}
proc getHtmlTitle {w} {
	set titleStart [lindex [$::documentationTopLevel.html token find title] 0]
	set titleEnd [lindex [$::documentationTopLevel.html token getend $titleStart] 0]
	incr titleStart
	incr titleEnd -1
	return "Documentation: [$::documentationTopLevel.html text html $titleStart $titleEnd]"
}
proc getHtmlText {url} {
	if {![file exists $::urlRoot/$url]} {
		return [format $::notFoundPage $::urlRoot/$url]
	}
	set fd [open $::urlRoot/$url]
	set text [read -nonewline $fd]
	close $fd
	return $text
}
proc showDocumentation {{url ""}} {
	if {[string length $url] == 0} {
		set url $::rootDocument
	}
	if {![winfo exists $::documentationTopLevel]} {
		makeHtmlGui $::documentationTopLevel
	}
	wm deiconify $::documentationTopLevel
	raise $::documentationTopLevel
	if {[string first {#} $url] >= 0} {
		lappend ::visitedUrls $url
		set url [split $url {#}]
		set base [lindex $url 0]
		set uri [lindex $url 1]
		if {![string equal [$::documentationTopLevel.html cget -base] $base]} {
			$::documentationTopLevel.html clear
			$::documentationTopLevel.html parse [getHtmlText $base]
			$::documentationTopLevel.html configure -base $base
			set title [getHtmlTitle $::documentationTopLevel.html]
			wm title $::documentationTopLevel $title
			if {[string equal $title {Not Found}]} {
				return
			}
			update
			update idletasks
		}
		$::documentationTopLevel.html yview $uri
		return
	}
	$::documentationTopLevel.html clear
	$::documentationTopLevel.html parse [getHtmlText $url]
	$::documentationTopLevel.html configure -base $url
	wm title $::documentationTopLevel [getHtmlTitle $::documentationTopLevel.html]
	lappend ::visitedUrls $url
}
package require Tkhtml
package require BWidget

proc makeHtmlGui {{top ""}} {
	puts stderr "makeHtmlGui :$top:"
	if {[string length $top] > 0} {
		if {![winfo exists $top]} {
			toplevel $top
			wm protocol $top WM_DELETE_WINDOW [list wm withdraw $top]
			button $top.back -text Back -command [list goBack]
			pack $top.back -side top

			ScrolledWindow $top.sw
			html $top.html -hyperlinkcommand showDocumentation -bg white
			$top.sw setwidget $top.html
			pack $top.sw -expand 1 -fill both -side top
			bind HtmlClip <1> {
				set parent [winfo parent %W]
				set url [$parent href %x %y]
				if {[string length $url]} {
					eval [$parent cget -hyperlinkcommand] $url
				}
			}
			bind HtmlClip <Button-4> {
				%W yview scroll -5 units
			}
			bind HtmlClip <Button-5> {
				%W yview scroll 5 units
			}
		}
		puts stderr "wm deiconify $top"
		puts stderr "raise $top"
		wm deiconify $top
		raise $top
		puts stderr "wm deiconify $top"
		puts stderr "raise $top"
	}
}
set documentationTopLevel .documentation
#makeHtmlGui $documentationTopLevel
set ::rootDocument com/module-ix.html
set ::urlRoot docs.zip/docs
package require zipvfs
vfs::zip::Mount $script_path/docs.zip docs.zip
#showDocumentation $::rootDocument
