#*************************************************************************
#*
#*  $RCSfile: dispatch.tcl,v $
#*
#*  $Revision: 1.3 $
#*
#*  last change: $Author: wiede $ $Date: 2005/09/07 11:02:01 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#*	 - GNU Lesser General Public License Version 2.1
#*
#*  GNU Lesser General Public License Version 2.1
#*  =============================================
#*  Copyright 2005 Wolfgang Grosser
#*
#*  This library is free software; you can redistribute it and/or
#*  modify it under the terms of the GNU Lesser General Public
#*  License version 2.1, as published by the Free Software Foundation.
#*
#*  This library is distributed in the hope that it will be useful,
#*  but WITHOUT ANY WARRANTY; without even the implied warranty of
#*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#*  Lesser General Public License for more details.
#*
#*  You should have received a copy of the GNU Lesser General Public
#*  License along with this library; if not, write to the Free Software
#*  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#*  MA  02111-1307  USA
#*
#*
#*  Author: Wolfgang Grosser
#*
#*   All Rights Reserved.
#*
#*   Contributor(s): 
#*
#*
#************************************************************************/

package require Tk
package require Itk

catch {itcl::delete class Dispatch}

itcl::class Dispatch {
	inherit itk::Widget
	public method generate {event {w ""}}
	public method register {w eventActionList}
	public method connect {source sourceEvent targetEventList}
	public method action {w event action}
	public method getWidgets {event}
	public method getEvents {w}
	public method getConnectedEvents {}
	public method getConnections {}

	private method dispatch {eventList {subwindow ""}}

	private variable _events
	private variable _connectedEvents
}
itcl::body Dispatch::generate {event {w ""}} {
	if {[string length $w] == 0} {
		set w $itk_interior
	}
	set w [winfo id $w]
	event generate $itk_interior $event -subwindow $w
#	dispatch $event $w
}
itcl::body Dispatch::register {w eventActionList} {
	foreach {event action} $eventActionList {
		if {[info exists _events($event)]} {
			set idx [lsearch -exact $_events($event) $w]
			if {$idx >= 0} {
				set _events($event) [lreplace $_events($event) $idx $idx]
			}
		}
		lappend _events($event) $w
		bind $itk_interior $event [itcl::code $this dispatch $event %S]
		bind $w $event $action
	}
}
itcl::body Dispatch::dispatch {eventList {subwindow ""}} {
	foreach event $eventList {
		if {![info exists _events($event)]} {
			continue
		}
		foreach w $_events($event) {
			if {![winfo exists $w]} continue
			if {[string length $subwindow] > 0} {
				event generate $w $event -subwindow [winfo pathname $subwindow]
			} else {
				event generate $w $event
			}
		}
	}
}
itcl::body Dispatch::connect {source sourceEvent targetEventList} {
	foreach event $targetEventList {
		set _connectedEvents($event) 1
	}
	bind $source $sourceEvent [itcl::code $this dispatch $targetEventList [winfo id $source]]
}
itcl::body Dispatch::action {w event action} {
	bind $w $event $action
}
itcl::body Dispatch::getEvents {w} {
	set result [list]
	foreach event [array names _events] {
		if {[lsearch -exact $_events($event) $w] >= 0} {
			lappend result $event
		}
	}
	return $result
}
itcl::body Dispatch::getConnections {} {
	set result [list]
	foreach event [getConnectedEvents] {
		lappend result $event [getWidgets $event]
	}
	return $result
}
itcl::body Dispatch::getConnectedEvents {} {
	if {[info exists _connectedEvents]} {
		return [lsort [array names _connectedEvents]]
	}
	return [list]
}
itcl::body Dispatch::getWidgets {event} {
	if {[info exists _events($event)]} {
		return $_events($event)
	}
	return [list]
}
Dispatch .dispatch
grid .dispatch -row 1000
