#*************************************************************************
#*
#*  $RCSfile: variables.tcl,v $
#*
#*  $Revision: 1.14 $
#*
#*  last change: $Author: wiede $ $Date: 2005/12/05 12:22:57 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#* 	- BSD License
#*
#*	see file license.terms in this directory
#*
#*  Copyright 2005 Arnulf Wiedemann
#*
#*  Author: Arnulf Wiedemann
#*
#*  Contributor(s): 
#*
#************************************************************************/

namespace eval ::tclUrtpBridge {

# be careful!! the ordering here is relevant for decoding binary reply
variable hdrflag_names [list \
HDRFLAG_LONGHEADER \
HDRFLAG_REQUEST \
HDRFLAG_NEWTYPE \
HDRFLAG_NEWOID \
HDRFLAG_NEWTID \
HDRFLAG_LONGMETHODID \
HDRFLAG_IGNORECACHE \
HDRFLAG_MOREFLAGS \
HDRFLAG_SYNCHRONOUS \
HDRFLAG_MUSTREPLY \
HDRFLAG_EXCEPTION \
]

variable special_commands [list \
	[list ::tcluno::deleteObject 0 deleteObject "" ] \
	[list ::tcluno::generateUuid 0 generateUuid "" ] \
	[list ::tcluno::getMemberNames 0 getMemberNames "" ] \
	[list ::tcluno::getMemberMethodNames 0 getMemberMethodNames "" ] \
	[list ::tcluno::getMemberPropertyNames 0 getMemberPropertyNames "" ] \
	[list ::tcluno::getTclunoCommands 0 getTclunoCommands "" ] \
	[list ::tcluno::getHandleObject 1 getHandleObject "<cmd_handle>" ] \
	[list ::tcluno::getObjectInterfaces 1 getObjectInterfaces "<object_id>" ] \
	[list ::tcluno::checkAny 1 checkAny "<Any list>" ] \
	[list ::tcluno::checkByteSequence 1 checkByteSequence "<ByteSequence list>" ] \
	[list ::tcluno::checkChar 1 checkChar "<Char list>" ] \
	[list ::tcluno::checkEnum 1 checkEnum "<enum list>" ] \
	[list ::tcluno::checkType 1 checkType "<type name>" ] \
	[list ::tcluno::createUnoSequence 1 createUnoSequence "<sequence type name>" ] \
	[list ::tcluno::fileUrlToSystemPath 1 fileUrlToSystemPath, NULL, "<name>" ] \
	[list ::tcluno::getClass 1 getClass "<class_name>" ] \
	[list ::tcluno::getConstantByName 1 getConstantByName "<constant name>" ] \
	[list ::tcluno::getEnumInfos 1 getInterfaceEnumInfos "<class_name>" ] \
	[list ::tcluno::getMemberMethodInfos 1 getMemberMethodInfos "<command object>" ] \
	[list ::tcluno::getTclunoAny 1 getTclunoAny "<Any list>" ] \
	[list ::tcluno::getTclBoolean 1 getTclBoolean "<boolean name>" ] \
	[list ::tcluno::getTclunoByteSequence 1 getTclunoByteSequence "<ByteSequence list>" ] \
	[list ::tcluno::getTclunoChar 1 getTclunoChar "<char list>" ] \
	[list ::tcluno::getTclunoEnum 1 getTclunoEnum "<enum list>" ] \
	[list ::tcluno::getTclunoType 1 getTclunoType "<type list>" ] \
	[list ::tcluno::getTypeByName 1 getTypeByName "<type name>" ] \
	[list ::tcluno::isInterface 1 isInterface "<object>" ] \
	[list ::tcluno::systemPathToFileUrl 1 systemPathToFileUrl "<name>" ] \
	[list ::tcluno::absolutize 2 absolutize "<path> <rel>" ] \
	[list ::tcluno::appendUnoSequence 2 appendUnoSequence "<sequence object> <element object>" ] \
	[list ::tcluno::createUnoStructHelper 2 createUnoStructHelper "<struct name> <initializer list>" ] \
	[list ::tcluno::setPropertyValueByName 2 setPropertyValueByName "<name> <value>" ] \
	]

variable data

variable reply_headers
variable reply_body
variable headers
variable request
variable reply

variable object_cache
variable class_name_cache
variable method_ids
variable param_id_infos
variable remote_objects

variable local_thread_cache
variable local_thread_cache_names

variable remote_type_cache
variable remote_type_cache_names
variable remote_thread_cache
variable remote_thread_cache_names
variable remote_object_cache
variable remote_object_cache_names
variable remote_object_sent
variable remote_type_objects
variable remote_object_types

variable generated_command_infos
variable generated_sequences
variable generated_sequence_sizes
variable generated_structs
variable generated_specials
variable remote_object_interfaces
variable remote_interface_objects
variable interface_methods
variable interface_properties
variable method_interfaces
variable method_return_types
variable object_interfaces
variable loaded_interfaces
variable loaded_modules
variable loaded_structs
variable loaded_enums
variable loaded_constants
variable loaded_interface_methods
variable struct_infos
variable enum_infos
variable constant_infos
variable exception_infos
variable object_ref_counts
variable object_type_indexes
variable index_object_types

# **************************** InitVariables ***************************

proc InitVariables {} {
	variable data

	variable type_cache
	variable thread_cache
	variable object_cache
	variable class_name_cache
	variable local_thread_cache
	variable local_thread_cache_names
	variable loaded_interfaces
	variable remote_type_cache
	variable remote_type_cache_names
	variable remote_thread_cache
	variable remote_thread_cache_names
	variable remote_object_cache
	variable remote_object_cache_names
	variable generated_command_infos
	variable method_ids
	variable remote_object_types
	variable remote_type_objects
	variable method_infos
	variable method_return_types
	variable method_interfaces
	variable interface_methods
	variable remote_object_interfaces
	variable remote_interface_objects
	variable method_modes
	variable method_infos

	InitLog
	InitBootstrapVariables

	set data(had_request) 0
	set data(handled_commands) 0
	set data(curr_type_cache_index) 0
	set data(remote_object_cache_index) 0
	set data(remote_thread_cache_index) 0
	set data(remote_type_cache_index) 0
	set data(last_local_thread_id) 0
	set data(last_remote_thread_id) -2
	set data(last_remote_type_id) -2
	set data(local_thread_cache_index) 0
	set data(generated_command_index) 0
	set data(generated_sequence_index) 0
	set data(generated_struct_index) 0
	set data(generated_special_index) 0
	set data(handle_idx) 0
	set data(message_id) 0
	set data(reply_message_id) 0
	set data(reply_magic) [list]
	set data(reply_size) [list]
	set data(connection_fd) [list]
	set data(curr_handle_index) -1
	set data(no_log) 1
	set data(is_getImplementationId) 0
	set data(had_error) 0
	set data(free_object_cache_index) -1
	set data(add_thread_id) -1
	set data(localContext) [list]
	set data(remote_service_manager) -1
	set data(type_description_manager) -1
	set data(unknown_info) "???"
	set data(implementation_id_info) [list]
	set data(curr_method_name) [list]
	set data(curr_interface_name) [list]
	set data(generated_commands) [list]
	set data(needed_interfaces) [list]
	set data(remote_component_context) -1
	set data(initial_object_id_name) StarOffice.ComponentContext
	set data(initial_object_id_idx) -3
	set data(local_context) -3
	set data(free_object_type_indexes) [list]
	set data(max_object_type_index) -1
	set data(have_x_interface_type_description) 0
	set data(need_new_thread_id) 0
	if {$data(send_binary)} {
		set data(buildSendMessage) buildBinarySendMessage
		set data(readReply) readBinaryReply
	} else {
		set data(buildSendMessage) buildTextSendMessage
		set data(readReply) readTextReply
	}
	set data(binary_stack_idx) 0

	InitMarshal


	catch {unset type_cache}
	catch {unset thread_cache}
	catch {unset object_cache}
	catch {unset class_name_cache}
	catch {unset local_thread_cache}
	catch {unset local_thread_cache_names}
	catch {unset loaded_interfaces}
	catch {unset remote_type_cache}
	catch {unset remote_type_cache_names}
	catch {unset remote_thread_cache}
	catch {unset remote_thread_cache_names}
	catch {unset remote_object_cache}
	catch {unset remote_object_cache_names}
	catch {unset method_ids}
	catch {unset struct_infos}
	catch {unset enum_infos}
	catch {unset loaded_structs}
	catch {unset loaded_enums}
	catch {unset exception_infos}
	catch {unset remote_object_types}
	catch {unset remote_type_objects}
	catch {unset remote_object_interfaces}
	catch {unset remote_interface_objects}
	catch {unset object_interfaces}
	catch {unset method_return_types}
	catch {unset method_interfaces}
	catch {unset interface_methods}
	catch {unset method_modes}
	catch {unset method_infos}
	# need to destroy the generated commands here !!
	catch {unset generated_command_infos}

	# bootstrapping problem: have to use "hardwired" method numbers
	# --------- XInterface
	set method_ids(com.sun.star.uno.XInterface,queryInterface) 0
	set method_ids(com.sun.star.uno.XInterface,acquire) 1
	set method_ids(com.sun.star.uno.XInterface,release) 2

	# --------- XComponentContext
	set method_ids(com.sun.star.uno.XComponentContext,getValueByName) 3
	set method_ids(com.sun.star.uno.XComponentContext,getServiceManager) 4

	# --------- XTypeDescriptionEnumerationAccess
	set method_ids(com.sun.star.reflection.XTypeDescriptionEnumerationAccess,createTypeDescriptionEnumeration) 3

	# --------- XEnumeration
	set method_ids(com.sun.star.container.XEnumeration,hasMoreElements) 3
	set method_ids(com.sun.star.container.XEnumeration,nextElement) 4

	# --------- XTypeDescription
	set method_ids(com.sun.star.reflection.XTypeDescription,getTypeClass) 3
	set method_ids(com.sun.star.reflection.XTypeDescription,getName) 4

	# --------- XCompoundTypeDescription
	set method_ids(com.sun.star.reflection.XCompoundTypeDescription,getBaseType) 5
	set method_ids(com.sun.star.reflection.XCompoundTypeDescription,getMemberTypes) 6
	set method_ids(com.sun.star.reflection.XCompoundTypeDescription,getMemberNames) 7

	# --------- XInterfaceTypeDescription
	set method_ids(com.sun.star.reflection.XInterfaceTypeDescription,getBaseType) 5
	set method_ids(com.sun.star.reflection.XInterfaceTypeDescription,getMembers) 7

	# --------- XInterfaceMemberTypeDescription
	set method_ids(com.sun.star.reflection.XInterfaceMemberTypeDescription,getMemberName) 5
	set method_ids(com.sun.star.reflection.XInterfaceMemberTypeDescription,getPosition) 6

	# --------- XIdlClass
	set method_ids(com.sun.star.reflection.XIdlClass,getTypeClass) 7
	set method_ids(com.sun.star.reflection.XIdlClass,getMethods) 16

	# --------- XIdlReflection
	set method_ids(com.sun.star.reflection.XIdlReflection,forName) 3
	set method_ids(com.sun.star.reflection.XIdlReflection,getType) 4

	# --------- XIdlMethod
	set method_ids(com.sun.star.reflection.XIdlMethod,getReturnType) 5
	set method_ids(com.sun.star.reflection.XIdlMethod,getParameterTypes) 6
	set method_ids(com.sun.star.reflection.XIdlMethod,getParameterInfos) 7
	set method_ids(com.sun.star.reflection.XIdlMethod,getExceptionTypes) 8
	set method_ids(com.sun.star.reflection.XIdlMethod,getMode) 9
	set method_ids(com.sun.star.reflection.XIdlMethod,invoke) 10

	# --------- XEnumTypeDescription
	set method_ids(com.sun.star.reflection.XEnumTypeDescription,getDefaultEnumValue) 5
	set method_ids(com.sun.star.reflection.XEnumTypeDescription,getEnumNames) 6
	set method_ids(com.sun.star.reflection.XEnumTypeDescription,getEnumValues) 7

	set method_ids(com.sun.star.container.XHierarchicalNameAccess,getByHierarchicalName) 3

	trace add variable method_ids [list array read] checkMethodIdExists
	# need to initialize the variable so that the trace works!!
	set method_infos(_xx) yy
	trace add variable method_infos [list array read] checkMethodInfosExists
}

# **************************** Init ************************************

proc Init {} {
	InitVariables
}

}
