#*************************************************************************
#*
#*  $RCSfile: utils.tcl,v $
#*
#*  $Revision: 1.20 $
#*
#*  last change: $Author: wiede $ $Date: 2005/12/05 12:22:57 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following licenses
#*
#* 	- BSD License
#*
#*	see file license.terms in this directory
#*
#*  Copyright 2005 Arnulf Wiedemann
#*
#*  Author: Arnulf Wiedemann
#*
#*  Contributor(s): 
#*
#************************************************************************/

namespace eval ::tclUrtpBridge {

# **************************** getHandleObject *************************

proc getHandleObject {handle} {
	variable data
	variable generated_command_infos

	regsub {::tclUrtpBridge::handle_} $handle {} cmd_idx
	set my_info $generated_command_infos($cmd_idx)
	set my_info0 [lindex $my_info 0]
	set class_info [list]
	set invocation_info [list]
	foreach {object_info class_info invocation_info introspection_info} $my_info0 break
	foreach {index_info id_info} $object_info break
	foreach {type1 object_idx} $index_info break
	foreach {type2 oid} $id_info break
	set data(handle_oid) $oid
	if {[llength $class_info] > 0} {
		foreach {index_info id_info} $class_info break
		foreach {type1 class1} $index_info break
		foreach {type2 class_name} $id_info break
		switch $class_name {
		interface {
		  	set class_name com.sun.star.uno.XInterface
		  }
		}
	} else {
		set class_name unknown
	}
	set data(handle_type) $class_name
	if {[llength $invocation_info] > 0} {
		foreach {type1 invocation_oid} $invocation_info break
	} else {
		set invocation_oid [list]
	}
	set data(invocation_oid) $invocation_oid
	if {[llength $introspection_info] > 0} {
		foreach {type1 introspection_oid} $introspection_info break
	} else {
		set introspection_oid [list]
	}
	set data(handle_introspection_oid) $introspection_oid
	return $oid
}

# **************************** getHandleObjectInfo *********************

proc getHandleObjectInfo {handle} {
	variable data
	variable generated_command_infos

	regsub {::tclUrtpBridge::handle_} $handle {} cmd_idx
	set my_info $generated_command_infos($cmd_idx)
	set my_info0 [lindex $my_info 0]
	foreach {object_info class_info invocation_info introspection_info} $my_info0 break
	foreach {index_info id_info} $object_info break
	foreach {type1 object_idx} $index_info break
	foreach {type2 oid} $id_info break
	return $oid
}

# **************************** getInterfaceAndObject *******************

proc getInterfaceAndObject {infos} {
	foreach {type_info value_info object_info} $infos break
	foreach {type type_name} $value_info break
	set oid [list]
	foreach {type oid} $object_info break
	return [list $type_name $oid]
}

# **************************** queryInterface **************************

proc queryInterface {oid name} {
	variable data
	variable remote_object_cache
	variable remote_type_cache
	variable remote_type_cache_names
	variable local_requested_type_names

	set data(is_tmp_object) 0
	set new_thread 0
	set new_object 1
	if {[string length $oid] == 0} {
		# that is the initial object!!
		set oid $data(initial_object_id_name)
		set my_oid_cache_idx 0
	} else {
		set my_oid_cache_idx $remote_object_cache($oid)
	}
	set data(curr_oid) $oid
	set method_id [getMethodId com.sun.star.uno.XInterface queryInterface]
SendDebug 1 "QI:$method_id:$name:my_oid_cache_idx:$my_oid_cache_idx:oid:$oid:"
	set data(curr_method_name) queryInterface
	set data(curr_interface_name) $name
	set data(curr_method_id) $method_id
	set data(object_id_interface) $name
	set new_type 1
	set new_thread_id $data(need_new_thread_id)
	if {$new_object} {
		startLongRequest $new_thread $new_type $new_object $method_id
		if {$new_type} {
			appendInterfaceRequestElement com.sun.star.uno.XInterface
		}
SendDebug 2 "NN2:$oid:$my_oid_cache_idx:"
		appendRequestElement OBJECT_ID $oid
		appendRequestElement OBJECT_CACHE_INDEX $my_oid_cache_idx
		if {$new_thread_id} {
			set data(last_local_thread_id) 0
			set my_thread_id [getLocalThread $data(last_local_thread_id)]
			appendRequestElement THREAD_ID_SIZE 20
			appendRequestElement THREAD_ID $my_thread_id
			appendRequestElement THREAD_CACHE_INDEX $data(last_local_thread_id)
		}
	} else {
		startShortRequest $method_id
	}
	appendInterfaceRequestElement $name
	set my_result [sendRequest]
	if {[string length $my_result] == 0} {
		return [list]
	}
	if {[llength $my_result] == 1} {
		set my_result [lindex $my_result 0]
		if {[string compare $my_result "TYPE_CLASS VOID"] == 0} {
			# the object has no such interface!!
SendDebug 1 "WARNING:object has no such interface:$name:"
			if {[info exists local_requested_type_names($name)]} {
				if {$local_requested_type_names($name)} {
					catch {unset local_requested_type_names($name)}
					set my_type_cache_idx $remote_type_cache($name)
puts stderr "unset:$name:$my_type_cache_idx:"
					catch {unset remote_type_cache($name)}
					catch {unset remote_type_cache_names($my_type_cache_idx)}
				}
			}
			return [list]
		}
	}
	set my_infos [getInterfaceAndObject $my_result]
	foreach {my_type_name my_oid} $my_infos break
SendDebug 1 "QI:END:$name:$my_type_name:$my_oid:"
	return $my_oid
}

# **************************** _callMethod ******************************

proc _callMethod {oid interface_name method_name args} {
	variable data
	variable remote_object_cache
	variable remote_type_cache
	variable remote_object_types
	variable released_objects

	set data(is_tmp_object) 0
	set data(curr_oid) $oid
	set method_id [getMethodId $interface_name $method_name]
SendDebug 1 "CM:$method_id:$method_name:$interface_name:oid:$oid:"
	set data(curr_method_name) $method_name
	set data(curr_interface_name) $interface_name
	set data(curr_method_id) $method_id
	if {[info exists remote_object_types($oid)]} {
		set data(object_id_interface) $remote_object_types($oid)
	} else {
		set data(object_id_interface) [list]
	}
	set my_type_cache_idx [getRemoteTypeCacheIndex $interface_name]
	set new_thread_id 0
	set new_type 1
	set new_object_id 1
	if {$new_object_id} {
		startLongRequest $new_thread_id $new_type $new_object_id $method_id
		appendInterfaceRequestElement $interface_name
		set oid_cache_idx $remote_object_cache($oid)
		set data(call_method_object) $oid
		if {$new_object_id} {
			appendRequestElement OBJECT_ID $oid
			appendRequestElement OBJECT_CACHE_INDEX $oid_cache_idx
		}
	} else {
		startShortRequest $method_id
	}
	if {$data(add_thread_id) > 0} {
		set my_thread_id [getLocalThread $data(last_local_thread_id)]
		appendRequestElement THREAD_ID_SIZE 20
		appendRequestElement THREAD_ID $my_thread_id
		set my_thread_cache_idx $data(last_local_thread_id)
		incr my_thread_cache_idx
		appendRequestElement THREAD_CACHE_INDEX $my_thread_cache_idx
		set data(add_thread_id) -1
	} else {
		if {$data(add_thread_id) == 0} {
			appendRequestElement THREAD_ID_SIZE 0
			appendRequestElement THREAD_CACHE_INDEX 0
			set data(add_thread_id) -1
		}
	}
	if {[llength $args] > 0} {
		appendRequestInfos $args
	}
	set ret [sendRequest]
SendDebug 1 "CM:END:$method_name:$ret:"
	return $ret
}

# **************************** callMethod ******************************

proc callMethod {oid interface_name method_name args} {
	variable data
	variable remote_type_cache
	variable binary_hdr_flag_values

	set data(repeat_call_method) 0
	set cmd [list _callMethod $oid $interface_name $method_name]
	set cmd [concat $cmd $args]
	set result [eval $cmd]
	if {$data(repeat_call_method)} {
		if {$binary_hdr_flag_values(HDRFLAG_NEWTYPE)} {
			set my_idx $remote_type_cache($data(curr_interface_name))
		}
		if {$binary_hdr_flag_values(HDRFLAG_NEWOID)} {
		}
		set data(repeat_call_method) 0
		set result [eval $cmd]
	}
	return $result
}

# **************************** getObjectInterfaces *********************

proc getObjectInterfaces {oid} {
	variable data

	set my_object_id [queryInterface $oid com.sun.star.lang.XTypeProvider]
	set data(primary_return_type_name) SEQUENCE
	set data(primary_return_class_name) {[]type}
	set my_types [callMethod $oid com.sun.star.lang.XTypeProvider getTypes]
	set my_interfaces [getRemoteSequenceTypeNames $my_types]
	return $my_interfaces
}

# **************************** getIntrospectionObjectId ****************

proc getIntrospectionObjectId {} {
	variable data

	set need_remote_service_manager 0
	if {(![info exists data(remote_service_manager)])} {
		set need_remote_service_manager 1
	} else {
		if {$data(remote_service_manager) < 0} {
			set need_remote_service_manager 1
		}
	}
	if {$need_remote_service_manager} {
		set result_info [callMethod $data(remote_component_context) com.sun.star.uno.XComponentContext getServiceManager]
		set my_oid [storeObjectInfo com.sun.star.uno.XComponentContext [lindex $result_info 0]]
		set data(remote_service_manager) $my_oid
	}
	if {![info exists data(introspection)]} {
		set my_oid [queryInterface $data(remote_service_manager) com.sun.star.lang.XMultiComponentFactory]
		set data(multi_component_factory) $my_oid
		set oid_cache_idx $remote_object_cache($data(remote_component_context))
		set result_info [callMethod $data(multi_component_factory) com.sun.star.lang.XMultiComponentFactory createInstanceWithContext [list STRING com.sun.star.beans.Introspection] [list OBJECT_ID [list]] [list OBJECT_CACHE_INDEX $oid_cache_idx]]
		set my_oid [storeObjectInfo com.sun.star.beans.Introspection [lindex $result_info 0]]
		set data(introspection) $my_oid
	}
	set my_oid [queryInterface $data(introspection) com.sun.star.beans.XIntrospection]
	return $my_oid 
}

# **************************** getMethodInterface **********************

proc getMethodInterface {oid method_name} {
	variable data
	variable method_interfaces
	variable object_interfaces
	variable remote_object_cache_names

	set data(curr_method_interface) [list]
#puts stderr "OID_INF:$method_name\n[join [lsort $object_interfaces($oid)] \n]:"
	if {![info exists method_interfaces($method_name)]} {
		if {![info exists object_interfaces($oid)]} {
			puts stderr "ERROR: missing interfaces for oid:$oid:!!"
		} else {
			set my_object_interfaces $object_interfaces($oid)
			foreach my_interface $my_object_interfaces {
				getInterfaceMethodInfos $my_interface $oid
			}
		}
	}
	if {![info exists object_interfaces($oid)]} {
		puts stderr "ERROR: missing interfaces for oid:$oid:!!"
	} else {
		if {[info exists method_interfaces($method_name)]} {
			foreach my_interface $method_interfaces($method_name) {
				if {[lsearch $object_interfaces($oid) $my_interface] >= 0} {
					set data(curr_method_interface) $my_interface
					break
				}
			}
		} else {
			switch $method_name {
			getByName {
				set data(curr_method_interface) com.sun.star.container.XNameAccess
			  }
			getCellByPosition {
				set data(curr_method_interface) com.sun.star.table.XCellRange
			  }
			}
			puts stderr "ERROR: no method_interfaces for $method_name found!!:"
		}
	}
	if {[string length $data(curr_method_interface)] == 0} {
		if {[info exists method_interfaces($method_name)]} {
			if {[llength $method_interfaces($method_name)] == 1} {
				set data(curr_method_interface) [lindex $method_interfaces($method_name) 0]
			} else {
				return $method_interfaces($method_name)
			}
		}
	}
	if {[string length $data(curr_method_interface)] == 0} {
		puts stderr "missing interface for method:$method_name!!"
	}
	return [list $data(curr_method_interface)]
}

}
