#*************************************************************************
#*
#*  $RCSfile: type_reflection.tcl,v $
#*
#*  $Revision: 1.17 $
#*
#*  last change: $Author: wiede $ $Date: 2005/12/05 12:22:57 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#* 	- BSD License
#*
#*	see file license.terms in this directory
#*
#*  Copyright 2005 Arnulf Wiedemann
#*
#*  Author: Arnulf Wiedemann
#*
#*  Contributor(s): 
#*
#************************************************************************/

namespace eval ::tclUrtpBridge {

# **************************** getMethodParameterInfos *****************

proc getMethodParameterInfos {interface_name method_name} {
	variable data
	variable method_infos

	set result_infos [callMethod $data(get_method_oid) com.sun.star.reflection.XIdlMethod getParameterInfos]
	set param_infos [getSequenceParamInfos $result_infos]
	set method_infos(params,$interface_name,$method_name,num_params) [llength $param_infos]
	set param_number 0
	set param_type_oids [list]
	foreach entry $param_infos {
		foreach {param_name param_mode param_type_oid} $entry break
		set param_type_name_infos [callMethod $param_type_oid com.sun.star.reflection.XIdlClass getName]
		set param_type [getStringValue [lindex $param_type_name_infos 0]]
		set method_infos(params,$interface_name,$method_name,$param_number) [list $param_type $param_name $param_mode]
		if {[lsearch $param_type_oids $param_type_oid] < 0} {
			lappend param_type_oids $param_type_oid
		}
		incr param_number
	}
	foreach param_type_oid $param_type_oids {
		releaseTypeObject com.sun.star.reflection.XIdlClass $param_type_oid
	}
}

# **************************** getTypeClassFromName ********************

proc getTypeClassFromName {type_name} {
	variable data
	variable type_type_classes
	variable type_class_type_class_names

	if {[info exists type_class_type_class_names($type_name)]} {
		set my_type_name $type_class_type_class_names($type_name)
	} else {
		set result_infos [callMethod $data(idl_reflection) com.sun.star.reflection.XIdlReflection forName [list STRING $type_name]]
		set my_oid [storeObjectInfo com.sun.star.uno.XInterface [lindex $result_infos 0]]
		set result_infos [callMethod $my_oid com.sun.star.reflection.XIdlClass getTypeClass]
		set my_type_class [getEnumValue [lindex $result_infos 0]]
		set my_type_name $data(typeclass,$my_type_class)
		set type_class_type_class_names($type_name) $my_type_name
	}
	return $my_type_name
}

# **************************** getMethodReturnInfos ********************

proc getMethodReturnInfos {interface_name method_name} {
	variable data
	variable method_infos
	variable marshal_method_return_types

	set result_infos [callMethod $data(get_method_oid) com.sun.star.reflection.XIdlMethod getReturnType]
	set return_oid [storeObjectInfo com.sun.star.uno.XInterface [lindex $result_infos 0]]
	set return_name_infos [callMethod $return_oid com.sun.star.reflection.XIdlClass getName]
	set return_type_name [getStringValue [lindex $return_name_infos 0]]
	set return_type_infos [callMethod $return_oid com.sun.star.reflection.XIdlClass getTypeClass]
	set return_type_class_value [getEnumValue [lindex $return_type_infos 0]]
	set return_type_class $data(typeclass,$return_type_class_value)
	set method_infos(return,$interface_name,$method_name,return_type_name) $return_type_name
	set method_infos(return,$interface_name,$method_name,return_type_class) $return_type_class
	switch $return_type_class {
	INTERFACE {
	  	set marshal_type interface
	  }
	SEQUENCE {
	  	set my_val [string range $return_type_name 2 end]
		switch -glob $my_val {
		"*.*" {
			set marshal_type \[\]interface
		  }
		default {
		  	set marshal_type $return_type_name
		  }
		}
	  }
	default {
	  	set marshal_type $return_type_name
	  }
	}
	if {[info exists marshal_method_return_types($interface_name,$method_name)]} {
		if {[string compare $marshal_type $marshal_method_return_types($interface_name,$method_name)] != 0} {
			puts stderr "DIFFS:$marshal_type:$marshal_method_return_types($interface_name,$method_name):"
		}
	} else {
		set marshal_method_return_types($interface_name,$method_name) $marshal_type
	}
	releaseTypeObject com.sun.star.reflection.XIdlClass $return_oid
}

# **************************** getMethodModeInfos **********************

proc getMethodModeInfos {interface_name method_name} {
	variable data
	variable method_infos

	set result_infos [callMethod $data(get_method_oid) com.sun.star.reflection.XIdlMethod getMode]
	set mode_value [getEnumValue [lindex $result_infos 0]]
	switch $mode_value {
	0 {
		set method_mode ONEWAY
	  }
	1 {
		set method_mode TWOWAY
	  }
	default {
		set method_mode $data(unknown_info)
	  	puts stderr "ERROR: funny method_mode:$method_mode in getMethodModeInfos"
	  }
	}
	set method_infos(mode,$interface_name,$method_name,mode) $method_mode
}

# **************************** checkMethodInfosExists ******************

proc checkMethodInfosExists {name1 name2 op} {
	variable data
	variable method_infos

	set flds [split $name2 {,}]
	foreach {my_type my_interface my_method_name my_kind} $flds break
	if {![info exists ${name1}($name2)]} {
#	|| ([string compare $my_interface_name com.sun.star.lang.XSingleServiceFactory] == 0)
		if {![info exists data(get_method_oid)]} {
			set result_infos [callMethod $data(handle_introspection_oid) com.sun.star.beans.XIntrospectionAccess getMethod [list STRING $my_method_name] [list LONG -1]]
			set my_method_oid [storeObjectInfo com.sun.star.uno.XInterface [lindex $result_infos 0]]
			set data(get_method_oid) $my_method_oid
		}
		switch $my_type {
		params {
		  	getMethodParameterInfos $my_interface $my_method_name
		  }
		return {
		  	getMethodReturnInfos $my_interface $my_method_name
		  }
		mode {
		  	getMethodModeInfos $my_interface $my_method_name
		  }
		default {
		  	puts stderr "ERROR: checkMethodInfosExists:$name1:$name2:funny my_type:$my_type:"
		  }
		}
		if {[info exists data(get_method_oid)]} {
			releaseTypeObject com.sun.star.reflection.XIdlMethod $my_method_oid
			unset data(get_method_oid)
		}
	}
}

# **************************** queryMethodInfos ************************

proc queryMethodInfos {interface_name method_name} {
	variable data

	set result_infos [callMethod $data(handle_introspection_oid) com.sun.star.beans.XIntrospectionAccess getMethod [list STRING $method_name] [list LONG -1]]
	set my_method_oid [storeObjectInfo com.sun.star.uno.XInterface [lindex $result_infos 0]]
	set data(get_method_oid) $my_method_oid
	getMethodParameterInfos $interface_name $method_name
	getMethodReturnInfos $interface_name $method_name
	getMethodModeInfos $interface_name $method_name
	releaseTypeObject com.sun.star.reflection.XIdlMethod $my_method_oid
	unset data(get_method_oid)
}

# **************************** getNumMethodParameters ******************

proc getNumMethodParameters {interface_name method_name} {
	variable data
	variable method_infos

	return $method_infos(params,$interface_name,$method_name,num_params)
}

# **************************** getMethodParameterInfo ******************

proc getMethodParameterInfo {interface_name method_name param_no} {
	variable data
	variable method_infos

	return $method_infos(params,$interface_name,$method_name,$param_no)
}

# **************************** getMethodReturnTypeName *****************

proc getMethodReturnTypeName {interface_name method_name} {
	variable data
	variable method_infos

	return $method_infos(return,$interface_name,$method_name,return_type_name)
}

# **************************** getMethodReturnTypeClass ***************

proc getMethodReturnTypeClass {interface_name method_name} {
	variable data
	variable method_infos

	return $method_infos(return,$interface_name,$method_name,return_type_class)
}

# **************************** getMethodMode ***************************

proc getMethodMode {interface_name method_name} {
	variable data
	variable method_infos

	return $method_infos(mode,$interface_name,$method_name,mode)
}

# **************************** getByHierarchicalName *******************

proc getByHierarchicalName {interface_name} {
	variable data

ReflectionDebug 2 "MI2:INTERFACE_NAME:$interface_name:"
	set result_infos [callMethod $data(hierarchical_name_access) com.sun.star.container.XHierarchicalNameAccess getByHierarchicalName [list STRING $interface_name]]
	set my_info [getInterfaceAndObject $result_infos]
	foreach {td_interface_name td_oid} $my_info break
	set data(last_received_oid) $td_oid
	set data(name_access_type_oid) $td_oid
	set data(name_access_type_name) $td_interface_name
	return $td_oid
}

# **************************** getInterfaceConstantsInfos **************

proc getInterfaceConstantsInfos {interface_name} {
	variable data
	variable loaded_constants
	variable constants_infos
	variable remote_object_cache
	variable type_type_classes

	if {[info exists loaded_constants($interface_name)]} {
		return
	}
ReflectionDebug 1 "CONSTANTS:INTERFACE_NAME:$interface_name:"
	set loaded_constants($interface_name) 1
	set type_oid [getByHierarchicalName $interface_name]

	set type_type_classes($interface_name) CONSTANTS
	set member_name_infos [list]
	set my_interface_name com.sun.star.reflection.XConstantsTypeDescription
	queryInterface $type_oid $my_interface_name
	set result_infos [callMethod $type_oid $my_interface_name getConstants]
	set objs [getSequenceObjects $my_interface_name $result_infos]
	set cnt 0
	set constants_member_infos [list]
	foreach my_type_oid $objs {
		set my_interface com.sun.star.reflection.XConstantTypeDescription
#		queryInterface $my_type_oid $my_interface
		set result_infos [callMethod $my_type_oid $my_interface getConstantValue]
		set member_value [getStringValue [lindex $result_infos 0]]
ReflectionDebug 1 "CONSTANTS:$interface_name,$cnt:$member_value:"
		lappend constants_member_infos [list $member_value]
	}
	set constants_infos($interface_name) $constants_member_infos
	foreach my_oid [lsort -unique $objs] {
		releaseTypeObject com.sun.star.reflection.XConstantTypeDescription $my_oid
	}
}

# **************************** getInterfaceEnumInfos *******************

proc getInterfaceEnumInfos {interface_name} {
	variable data
	variable loaded_enums
	variable enum_infos
	variable remote_object_cache
	variable type_type_classes

	if {[info exists loaded_enums($interface_name)]} {
		return
	}
ReflectionDebug 1 "ENUM:INTERFACE_NAME:$interface_name:"
	set loaded_enums($interface_name) 1
	set type_oid [getByHierarchicalName $interface_name]

	set type_type_classes($interface_name) ENUM
	set member_name_infos [list]
	set my_interface_name com.sun.star.reflection.XEnumTypeDescription
	queryInterface $type_oid $my_interface_name
	set mm [callMethod $type_oid $my_interface_name getEnumNames]
	set member_names [getSequenceStrings $mm]
	set result_infos [callMethod $type_oid $my_interface_name getEnumValues]
	set member_values [getSequenceEnums $result_infos]
	set cnt 0
	set enum_member_infos [list]
	set lgth [llength $member_names]
	while {$cnt < $lgth} {
		set member_name [lindex $member_names $cnt]
		set value [lindex $member_values $cnt]
ReflectionDebug 1 "ENUM:$interface_name,$cnt:$member_name:$value:"
		lappend enum_member_infos [list $member_name $value]
		incr cnt
	}
	set enum_infos($interface_name) $enum_member_infos
}

# **************************** getInterfaceStructInfos ****************

proc getInterfaceStructInfos {interface_name} {
	variable data
	variable loaded_structs
	variable struct_infos
	variable remote_object_cache
	variable type_type_classes

	if {[info exists loaded_structs($interface_name)]} {
		return
	}
ReflectionDebug 1 "STRUCT:INTERFACE_NAME:$interface_name:"
	set loaded_structs($interface_name) 1
	set type_oid [getByHierarchicalName $interface_name]

	set type_type_classes($interface_name) STRUCT
	set member_name_infos [list]
	set my_interface_name com.sun.star.reflection.XCompoundTypeDescription
	queryInterface $type_oid $my_interface_name
	set mm [callMethod $type_oid $my_interface_name getMemberNames]
	set member_names [getSequenceStrings $mm]
	set result_infos [callMethod $type_oid $my_interface_name getMemberTypes]
	set objs [getSequenceObjects $my_interface_name $result_infos]
	set cnt 0
	set struct_member_infos [list]
	foreach my_type_oid $objs {
ReflectionDebug 2 "MEMBER_OID:$my_type_oid:"
		set member_name [lindex $member_names $cnt]
		set my_interface com.sun.star.reflection.XTypeDescription
#		queryInterface $my_type_oid $my_interface
		set stn [callMethod $my_type_oid $my_interface getName]
		set member_type [getStringValue [lindex $stn 0]]
ReflectionDebug 1 "STRUCT:$interface_name,$cnt:$member_name:$member_type:"
		lappend struct_member_infos [list $member_type $member_name]
		incr cnt
	}
	set struct_infos($interface_name) $struct_member_infos
	foreach my_oid [lsort -unique $objs] {
		releaseTypeObject com.sun.star.reflection.XTypeDescription $my_oid
	}
	releaseTypeObject $data(name_access_type_name) $data(name_access_type_oid)
}

# **************************** getInterfaceMethodInfos *****************

proc getInterfaceMethodInfos {interface_name oid} {
	variable data
	variable method_ids
	variable interface_methods
	variable method_interfaces
	variable loaded_interfaces
	variable loaded_modules
	variable param_id_infos
	variable struct_infos
	variable exception_infos
	variable remote_object_cache
	variable remote_object_cache_names

ReflectionDebug 1 "++++++++++ getInterfaceMethodInfos"
	if {[info exists loaded_interfaces($interface_name)]} {
		return
	}
ReflectionDebug 1 "INTERFACE:INTERFACE_NAME:$interface_name:"
	set loaded_interfaces($interface_name) 1
	set type_oid [getByHierarchicalName $interface_name]
	set type_type_classes($interface_name) INTERFACE
	if {![info exists interface_methods($interface_name)]} {
		set interface_methods($interface_name) [list]
	}
	set member_name_infos [list]
	set my_interface_name com.sun.star.reflection.XInterfaceTypeDescription
	set data(query_use_last_received_oid) 1
	queryInterface $type_oid $my_interface_name
	set data(query_use_last_received_oid) 1
	set mm [callMethod $type_oid $my_interface_name getMembers]
	catch {unset data(last_received_oid)}
	set objs [getSequenceObjects $my_interface_name $mm]
	foreach my_oid $objs {
ReflectionDebug 2 "MEMBER_OID:$my_oid:"
#		queryInterface $my_oid com.sun.star.reflection.XInterfaceMemberTypeDescription
		set mm1 [callMethod $my_oid com.sun.star.reflection.XInterfaceMemberTypeDescription getMemberName]
		set mm2 [callMethod $my_oid com.sun.star.reflection.XInterfaceMemberTypeDescription getPosition]
		set method_name [getStringValue [lindex $mm1 0]]
ReflectionDebug 1 "METHOD:$interface_name,$method_name:"
		set method_number [getLongValue [lindex $mm2 0]]
		if {[lsearch $interface_methods($interface_name) $method_name] < 0} {
			lappend interface_methods($interface_name) $method_name
		}
		if {![info exists method_interfaces($method_name)]} {
			set method_interfaces($method_name) [list]
		}
		if {[lsearch $method_interfaces($method_name) $interface_name] < 0} {
			lappend method_interfaces($method_name) $interface_name
		}
		set method_ids($interface_name,$method_name) $method_number
ReflectionDebug 1 "SET:$interface_name,$method_name:$method_number:"
	}
	foreach my_oid [lsort -unique $objs] {
		releaseTypeObject com.sun.star.reflection.XInterfaceMemberTypeDescription $my_oid
	}
	releaseTypeObject $data(name_access_type_name) $data(name_access_type_oid)
ReflectionDebug 1 "---------- getInterfaceMethodInfos"
}

# **************************** getInterfacePropertyInfos *****************

proc getInterfacePropertyInfos {interface_name oid} {
	variable data
	variable method_ids
	variable interface_properties
	variable method_interfaces
	variable loaded_interfaces
	variable loaded_modules
	variable param_id_infos
	variable struct_infos
	variable exception_infos
	variable remote_object_cache
	variable remote_object_cache_names

	if {[info exists loaded_interfaces($interface_name)]} {
		return
	}
ReflectionDebug 1 "INTERFACE_PROPERTIES:INTERFACE_NAME:$interface_name:"
	set loaded_interfaces($interface_name) 1
	set result_infos [callMethod $data(hierarchical_name_access) com.sun.star.container.XHierarchicalNameAccess getByHierarchicalName [list STRING $interface_name]]
	set my_info [getInterfaceAndObject $result_infos]
	foreach {td_interface_name td_oid} $my_info break
ReflectionDebug 1 "RM:$my_info:$td_interface_name:$td_oid:"

	set type_type_classes($interface_name) INTERFACE
	set loaded_interfaces($interface_name) 1
	if {![info exists interface_properties($interface_name)]} {
		set interface_properties($interface_name) [list]
	}
	set member_name_infos [list]
	set my_interface_name com.sun.star.reflection.XInterfaceTypeDescription
	queryInterface $td_oid $my_interface_name
	set mm [callMethod $td_oid $my_interface_name getMembers]
	set objs [getSequenceObjects $my_interface_name $mm]
	foreach my_oid $objs {
ReflectionDebug 2 "MEMBER_OID:$my_oid:"
#		set attr_oid [queryInterface $my_oid com.sun.star.reflection.XInterfaceMemberTypeDescription]
		set attr_oid $my_oid
ReflectionDebug 1 "ATTR_OID:$attr_oid:"
		set mm1 [callMethod $attr_oid com.sun.star.reflection.XInterfaceMemberTypeDescription getMemberName]
ReflectionDebug 1 "mm1:$mm1:"
		set property_name [getStringValue [lindex $mm1 0]]
		set result_infos [callMethod $data(invocation_oid) com.sun.star.script.XInvocation hasProperty [list STRING $property_name]]
		set has_property [getBooleanValue [lindex $result_infos 0]]
ReflectionDebug 1 "MM:$property_name:$has_property:"
ReflectionDebug 1 "PROPERTY:$interface_name,$property_name:$has_property:"
		if {$has_property} {
			if {[lsearch $interface_properties($interface_name) $property_name] < 0} {
				lappend interface_properties($interface_name) $property_name
			}
		}
ReflectionDebug 1 "MEMBER_OID2:$my_oid:"
	}
ReflectionDebug 1 "interface_properties:$interface_name:$interface_properties($interface_name):"
	foreach my_oid [lsort -unique $objs] {
		releaseTypeObject com.sun.star.reflection.XInterfaceMemberTypeDescription $my_oid
	}
	releaseTypeObject $td_interface_name $td_oid
}

# **************************** getInterfaceType ************************

proc getInterfaceType {interface_name oid} {
	variable data

	set result_infos [callMethod $data(hierarchical_name_access) com.sun.star.container.XHierarchicalNameAccess getByHierarchicalName [list STRING $interface_name]]
	set my_info [getInterfaceAndObject $result_infos]
	foreach {td_interface_name td_oid} $my_info break
ReflectionDebug 1 "InterfaceType:$my_info:$td_interface_name:$td_oid:"
	set my_oid $td_oid
	set result_infos [callMethod $my_oid com.sun.star.reflection.XTypeDescription getTypeClass]

	set value [getTypeClassedValue ENUM [lindex $result_infos 0]]
	return $data(typeclass,$value)
}

}
