#*************************************************************************
#*
#*  $RCSfile: tcluno_fcns.tcl,v $
#*
#*  $Revision: 1.21 $
#*
#*  last change: $Author: wiede $ $Date: 2005/12/25 15:55:07 $
#*
#*  The Contents of this file are made available subject to the terms of
#*  the following license
#*
#* 	- BSD License
#*
#*	see file license.terms in this directory
#*
#*  Copyright 2005 Arnulf Wiedemann
#*
#*  Author: Arnulf Wiedemann
#*
#*  Contributor(s): 
#*
#************************************************************************/

# **************************** ::tcluno:: internal commands START ******

namespace eval ::tclUrtpBridge {

# **************************** getTclunoType ***************************

proc getTclunoType {args} {
	set my_infos [lindex $args 0]
	foreach {type1 type_name type_class} $my_infos break
	return [list $type_class $type_name]
}

# **************************** getTclBoolean ***************************

proc getTclBoolean {val} {
	switch $val {
	True -
	true -
	1 {
	  	return [namespace current]::boolean_true
	  }
	False -
	false -
	0 {
		return [namespace current]::boolean_false
	}
	}
	puts stderr "ERROR: bad boolean in getTclBoolean:$val:"
	return $val
}

# **************************** getMemberNames **************************

proc getMemberNames {} {
	variable data
	variable interface_methods

	set my_property_names [getMemberPropertyNames]
	set my_method_names [getMemberMethodNames]
	set member_lst [concat $my_property_names $my_method_names]
	return $member_lst
}

# **************************** getMemberPropertyNames ******************

proc getMemberPropertyNames {} {
	variable data
	variable object_interfaces
	variable interface_properties
	variable remote_object_cache_names

#puts stderr "ME_PROP:"
	set my_object $data(handle_oid)
	set my_names [list]
	set result_infos [callMethod $data(invocation_oid) com.sun.star.script.XInvocation2 getMemberNames]
	set my_property_names [getSequenceStrings $result_infos]
#puts stderr "PN:$my_property_names:"
#puts stderr "HIOI:$data(handle_introspection_oid):"
	foreach my_interface [lsort [getObjectInterfaces $data(handle_oid)]] {
		if {![info exists interface_properties($my_interface)]} {
			getInterfacePropertyInfos $my_interface $data(handle_oid)
		}
		set my_property_names $interface_properties($my_interface)
		foreach name $my_property_names {
			if {[lsearch $my_names $name] < 0} {
				if {$with_interface} {
					lappend my_names [list $my_interface $name]
				} else {
					lappend my_names $name
				}
			}
		}
	}
puts stderr "MY:$my_names:"
	return $my_names
}

# **************************** getMemberMethodNames ********************

proc getMemberMethodNames {{with_interface 0}} {
	variable data
	variable object_interfaces
	variable interface_methods
	variable remote_object_cache_names

	set my_object $data(handle_oid)
	set my_names [list]
	set result_infos [callMethod $data(invocation_oid) com.sun.star.script.XInvocation2 getMemberNames]
	set method_infos [getSequenceElemInfos $result_infos]
	foreach {num_elems infos} $method_infos break
	set my_method_names [list]
	foreach entry $infos {
		foreach {type1 method_name} $entry break
		lappend my_method_names $method_name
	}
	foreach my_interface [lsort [getObjectInterfaces $data(handle_oid)]] {
		if {![info exists interface_methods($my_interface)]} {
			getInterfaceMethodInfos $my_interface $data(handle_oid)
		}
		set my_method_names $interface_methods($my_interface)
		foreach name $my_method_names {
			if {[lsearch $my_names $name] < 0} {
				if {$with_interface} {
					lappend my_names [list $my_interface $name]
				} else {
					lappend my_names $name
				}
			}
		}
	}
	return $my_names
}

# **************************** getCmdHandleIndex ***********************

proc getCmdHandleIndex {cmd_handle} {
	regsub {::tclUrtpBridge::} $cmd_handle {} my_handle
	# here we have: handle_nn or struct_nn or sequence_nn!!
	set my_flds [split $my_handle {_}]
	return [lindex $my_flds 1]
}

# **************************** getMemberMethodInfos ********************

proc getMemberMethodInfos {cmd_handle} {
	variable data
	variable generated_command_infos
	variable method_return_types
	variable param_id_infos

	set my_cmd_handle [getCmdHandleIndex $data(generated_command_args)]
	set my_oid [getHandleObject $my_cmd_handle]
	set result_infos [list]
	set with_interface 1
	set method_infos [getMemberMethodNames $with_interface]
	foreach entry $method_infos {
		foreach {my_interface method_name} $entry break
		if {![checkHasMethod $method_name]} {
			continue
		}
		set method_info_lst [list]
		lappend method_info_lst $method_name
		lappend method_info_lst [getMethodReturnTypeName $my_interface $method_name]
		set num_params [getNumMethodParameters $my_interface $method_name]
		set param_idx 0
		while {$param_idx < $num_params} {
			set my_param_infos [getMethodParameterInfo $my_interface $method_name $param_idx]
			foreach {param_type param_name param_mode} $my_param_infos break
			lappend method_info_lst [string tolower $param_mode]
			lappend method_info_lst $param_type
			lappend method_info_lst $param_name
			incr param_idx
		}
		lappend result_infos $method_info_lst
	}
	return $result_infos
}

# **************************** createUnoSequence ***********************

proc createUnoSequence {args} {
	variable data
	variable generated_sequences
	variable generated_sequence_sizes

	set type [lindex $args 0]
	set generated_sequences($data(generated_sequence_index)) $type
	set cmd [CreateCommand sequence [list [list SEQUENCE_INFO_INDEX $data(generated_sequence_index)] [list TYPE_CLASS $type]]]
	set generated_sequence_sizes($data(generated_sequence_index)) 0
	incr data(generated_sequence_index)
	return $cmd
}

# **************************** setPropertyValueByName ******************

proc setPropertyValueByName {args} {
	variable data
	variable generated_command_infos

	set my_handle_info [lindex $generated_command_infos($data(curr_handle_index)) 0]
	foreach {struct_info class_name_info init_info} $my_handle_info break
	foreach {type2 init_values} $init_info break
	if {[string length $init_values] == 0} {
		set init_values [list [list] -1 [list] 0]
	}
	foreach entry $args {
		foreach {name value} $entry break
#puts stderr "setPropertyValueByName $name:$value:"
		# TEMPORARY should use struct_infos !!
		switch $name {
		Name {
	  		set init_values [lreplace $init_values 0 0 $value]
		  }
		Handle {
		  	set init_values [lreplace $init_values 1 0 $value]
		  }
		Value {
		  	set init_values [lreplace $init_values 2 2 $value]
		  }
		State {
		  	set init_values [lreplace $init_values 3 3 $value]
		  }
		default {
		  	puts stderr "ERROR: bad Property member name: $name: ignoring!!"
		  }
		}
	}
	set my_handle_info [list $struct_info $class_name_info [list $type2 $init_values]]
	set generated_command_infos($data(curr_handle_index)) [lreplace $generated_command_infos($data(curr_handle_index)) 0 0 $my_handle_info]
}

# **************************** createUnoStructHelper *******************

proc createUnoStructHelper {args} {
	variable data
	variable generated_structs

	foreach {class_name init_values} $args break
	set generated_structs($data(generated_struct_index)) [list $class_name $init_values]
	set cmd [CreateCommand struct [list [list STRUCT_INFO_INDEX $data(generated_struct_index)] [list CLASS_NAME $class_name] [list INIT_VALUES $init_values]]]
	incr data(generated_struct_index)
	return $cmd
}

# **************************** appendUnoSequence ***********************

proc appendUnoSequence {args} {
	variable data
	variable generated_command_infos
	variable generated_sequence_sizes
	variable struct_infos
	variable enum_infos

	foreach {sequence_cmd struct_cmd} $args break
TclfcnsDebug 0 "AUS:$sequence_cmd:$struct_cmd:"
	set my_seq_cmd_idx [getCmdHandleIndex $sequence_cmd]
	set my_sequence_infos $generated_command_infos($my_seq_cmd_idx)
TclfcnsDebug 0 "AUS:2:$my_sequence_infos:"
	foreach {index_info type_info} [lindex $my_sequence_infos 0] break
	foreach {type1 my_seq_idx} $index_info break
	foreach {type2 sequence_type} $type_info break
	set infos [list]
	switch -glob -- $struct_cmd {
	"::*::sequence_*" -
	"::*::struct_*" {
		set my_cmd_idx [getCmdHandleIndex $struct_cmd]
		set my_struct_infos $generated_command_infos($my_cmd_idx)
TclfcnsDebug 1 "my_struct_infos:1:$my_struct_infos:"
		set init_values [list]
		foreach {index_info type_info init_info} [lindex $my_struct_infos 0] break
		foreach {type1 my_struct_idx} $index_info break
		foreach {type2 struct_type} $type_info break
		foreach {type3 init_values} $init_info break
		if {[llength $init_values] > 0} {
			if {![info exists struct_infos($struct_type)]} {
				getInterfaceStructInfos $struct_type
				if {![info exists struct_infos($struct_type)]} {
					puts stderr "===STRUCT:$struct_type:ERROR:no struct_infos found!!"
				} else {
					set my_struct_infos $struct_infos($struct_type)
				}
			} else {
				set my_struct_infos $struct_infos($struct_type)
			}
			set lgth [llength $my_struct_infos]
TclfcnsDebug 1 "my_struct_infos:2:$my_struct_infos:"
			if {[llength $init_values] != $lgth} {
				puts stderr "ERROR: appendUnoSequence:init_values has [llength $init_values] elems:expected: $lgth elems!!"
			}
			set elem_cnt 0
			while {$elem_cnt < $lgth} {
				set my_value [lindex $init_values $elem_cnt]
				set my_struct_elem_infos [lindex $my_struct_infos $elem_cnt]
				foreach {my_type my_name} $my_struct_elem_infos break
				set my_upper_type [string toupper $my_type]
TclfcnsDebug 1 "elem_cnt:$elem_cnt:$my_type:$my_name:"
				switch $my_upper_type {
				ANY {
					if {[string is integer $my_value] && ([string length $my_value] > 0)} {
						if {$my_value < 65535} {
							set type_class SHORT
						} else {
							set type_class LONG
						}
					} else {
						if {[string compare $my_value [namespace current]::boolean_true] == 0} {
							set type_class BOOLEAN
						  	set my_value True
						} else {
						    if {[string compare $my_value [namespace current]::boolean_false] == 0} {
							set type_class BOOLEAN
						  	set my_value False
						    } else {
							switch -glob $my_value {
							::tclUrtpBridge::sequence_* {
							  	set type_class SEQUENCE
							  }
							::tclUrtpBridge::struct_* {
							  	set type_class STRUCT
							  }
							default {
								set type_class STRING
						    	  }
							}
						    }
						}
					}
					lappend infos [list TYPE_CLASS $type_class]
					lappend infos [list $type_class $my_value]
				  }
				CHAR -
				BYTE -
				STRING -
				SHORT -
				LONG {
					lappend infos [list $my_upper_type $my_value]
				  }
				BOOLEAN {
					switch $my_value {
					1 -
					True -
					true {
					  	set my_value True
					  }
					0 -
					False -
					false {
					  	set my_value False
					  }
					default {
						puts stderr "ERROR: funny value for BOOLEAN:$my_value in appendUnoSequence!!"
					  }
					}
					lappend infos [list $my_upper_type $my_value]
				  }
				FLOAT -
				DOUBLE {
					lappend infos [list $my_upper_type $my_value]
				  }
				HYPER {
				  	puts stderr "ERROR:HYPER not yet implemented in appendSequenceInfos!!"
				  }
				default {
					if {![info exists enum_infos($my_type)]} {
						getInterfaceEnumInfos $my_type
					}
					if {[info exists enum_infos($my_type)]} {
						set ok 0
						if {[string is integer $my_value]} {
						    if {[string length $my_value] == 0} {
							set ok 1
						    } else {
							foreach entry $enum_infos($my_type) {
								foreach {my_name my_val} $entry break
								if {$my_value == $my_val} {
									set ok 1
									break
								}
							}
						    }
						} else {
						    if {[string length $my_value] == 0} {
							set ok 1
						    } else {
							foreach entry $enum_infos($my_type) {
								foreach {my_name my_val} $entry break
								if {[string compare $my_name $my_value] == 0} {
									set my_value $my_val
									set ok 1
									break
								}
							}
						    }
						}
						if {! $ok} {
							puts stderr "ERROR: FUNNY ENUM value:$my_value: for enum $my_type:"
						}
						lappend infos [list ENUM $my_value]
					} else {
				  		puts stderr "ERROR: appendUnoSequence:don't know how to handle:$my_upper_type:"
					}
				  }
				}
				incr elem_cnt
			}

		} else {
			set add_type 0
			if {[string length $sequence_type] == 0} {
				set add_type 1
			}
			switch $struct_type {
			"\[\]long" {
			  	set infos [lrange $my_struct_infos 1 end]
				if {$add_type} {
					set type_info [list $type2 "\[\]long"]
				}
			  }
			"\[\]double" {
			  	set infos [lrange $my_struct_infos 1 end]
				if {$add_type} {
					set type_info [list $type2 "\[\]double"]
				}
			  }
			"\[\]string" {
			  	set infos [lrange $my_struct_infos 1 end]
				if {$add_type} {
					set type_info [list $type2 "\[\]string"]
				}
			  }
			default {
				puts stderr "ERROR: funny struct type in appendUnoSequence:$struct_type:"
			  }
			}
			if {$add_type} {
				set generated_command_infos($my_seq_cmd_idx) [list [list $index_info $type_info]]
	  		}
		}
	  }
	default {
		set add_type 0
		if {[string length $sequence_type] == 0} {
			set add_type 1
		}
		if {[string is integer $struct_cmd]} {
	 		lappend infos [list TYPE_CLASS LONG]
			lappend infos [list LONG $struct_cmd]
			if {$add_type} {
				set type_info [list $type2 "\[\]long"]
			}
		} else {
		    if {[string is double $struct_cmd]} {
	 		lappend infos [list TYPE_CLASS DOUBLE]
			lappend infos [list DOUBLE $struct_cmd]
			if {$add_type} {
				set type_info [list $type2 "\[\]double"]
			}
		    } else {
	 		lappend infos [list TYPE_CLASS STRING]
			lappend infos [list STRING $struct_cmd]
			if {$add_type} {
				set type_info [list $type2 "\[\]string"]
			}
		    }
		}
		if {$add_type} {
			set generated_command_infos($my_seq_cmd_idx) [list [list $index_info $type_info]]
	  	}
	  }
	}
	if {[llength $infos] > 0} {
		lappend generated_command_infos($my_seq_cmd_idx) $infos
		incr generated_sequence_sizes($my_seq_idx)
  	}
}

# **************************** getTclunoChar ***************************

proc getTclunoChar {lst} {
	variable data
	variable generated_specials

	foreach {class_name value} $lst break
#	return [list [list TYPE_CLASS CHAR] [list VALUE $value]]
	return $value
}

# **************************** getTclunoType ***************************

proc getTclunoType {lst} {
	foreach {type_class interface_name type} $lst break
	set ret [list INTERFACE $interface_name]
	return $ret
}

# **************************** getTclunoEnum ***************************

proc getTclunoEnum {lst} {
	foreach {type_class enum_name value} $lst break
	return "[list TYPE_CLASS ENUM] [list VALUE $value]"
#	return $interface_name
}

# **************************** getTclunoAny ****************************

proc getTclunoAny {lst} {
	puts stderr "::tcluno::getTclunoAny not yet implemented!!"
}

# **************************** getTclunoByteSequence *******************

proc getTclunoByteSequence {lst} {
	puts stderr "::tcluno::getTclunoByteSequence not yet implemented!!"
}

# **************************** checkByteSequence ***********************

proc checkByteSequence {lst} {
	puts stderr "::tcluno::checkByteSequence not yet implemented!!"
}

# **************************** checkChar *******************************

proc checkChar {lst} {
	puts stderr "::tcluno::checkChar not yet implemented!!"
}

# **************************** checkType *******************************

proc checkType {lst} {
	puts stderr "::tcluno::checkType not yet implemented!!"
}

# **************************** checkEnum *******************************

proc checkEnum {lst} {
	puts stderr "::tcluno::checkEnum not yet implemented!!"
}

# **************************** checkAny ********************************

proc checkAny {lst} {
	puts stderr "::tcluno::checkAny not yet implemented!!"
}

}

# **************************** ::tcluno:: internal commands End ********

